/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.util.Optional;
import java.util.stream.Stream;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedBiConsumer;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.channel.ChannelAggregator;
import org.anchoranalysis.image.bean.nonbean.ConsistentChannelChecker;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.bean.combine.GroupedChannelAggregator;
import org.anchoranalysis.plugin.image.task.bean.grouped.GroupedStackBase;
import org.anchoranalysis.plugin.image.task.grouped.ChannelSource;
import org.anchoranalysis.plugin.image.task.grouped.GroupMapByName;

public class AggregateChannelTask
extends GroupedStackBase<Channel, ChannelAggregator> {
    @BeanField
    @OptionalBean
    private boolean slicewise;
    @BeanField
    private ChannelAggregator aggregator;
    @BeanField
    private String outputName;

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{this.outputName});
    }

    @Override
    protected Optional<String> subdirectoryForGroupOutputs() {
        return Optional.empty();
    }

    @Override
    protected String outputNameForGroups() {
        return this.outputName;
    }

    @Override
    protected GroupMapByName<Channel, ChannelAggregator> createGroupMap(ConsistentChannelChecker channelChecker, Optional<Stream<String>> groupIdentifiers, Optional<InputOutputContext> outputContext, OperationContext operationContext) {
        return new GroupedChannelAggregator<ChannelAggregator>(this.outputNameForGroups(), groupIdentifiers, outputContext, () -> (ChannelAggregator)this.aggregator.duplicateBean(), operationContext.getLogger());
    }

    @Override
    protected void processIndividual(String name, Channel individual, boolean partOfGroup, CheckedBiConsumer<String, Channel, OperationFailedException> consumeIndividual, InputOutputContext context) throws OperationFailedException {
        if (this.getResizeTo() != null) {
            if (this.slicewise) {
                this.addImagesSlicewise(consumeIndividual, name, individual);
            } else {
                this.addImageEntirety(consumeIndividual, name, individual.projectMax());
            }
        } else {
            this.addImageEntirety(consumeIndividual, name, individual);
        }
    }

    @Override
    protected CheckedFunction<Channel, Channel, CreateException> createChannelDeriver(ChannelSource source) throws OperationFailedException {
        return channel -> channel;
    }

    private void addImageEntirety(CheckedBiConsumer<String, Channel, OperationFailedException> addChannelToMap, String channelName, Channel channel) throws OperationFailedException {
        addChannelToMap.accept((Object)channelName, (Object)channel);
    }

    private void addImagesSlicewise(CheckedBiConsumer<String, Channel, OperationFailedException> addChannelToMap, String name, Channel channel) throws OperationFailedException {
        int numberSlices = channel.extent().z();
        for (int z = 0; z < numberSlices; ++z) {
            addChannelToMap.accept((Object)name, (Object)channel.extractSlice(z));
        }
    }

    public boolean isSlicewise() {
        return this.slicewise;
    }

    public void setSlicewise(boolean slicewise) {
        this.slicewise = slicewise;
    }

    public ChannelAggregator getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(ChannelAggregator aggregator) {
        this.aggregator = aggregator;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }
}

