/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.bean.channel.ChannelAggregator;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.bean.combine.OutputChannelsAsRGB;
import org.anchoranalysis.plugin.image.task.bean.combine.OutputChannelsSeparately;
import org.anchoranalysis.plugin.image.task.grouped.GroupMapByName;

class GroupedChannelAggregator<T extends ChannelAggregator>
extends GroupMapByName<Channel, T> {
    private final String outputNameDefault;

    public GroupedChannelAggregator(String outputName, Optional<Stream<String>> groupIdentifiers, Optional<InputOutputContext> outputContext, Supplier<T> createAggregator, Logger logger) {
        super("channel", groupIdentifiers, outputContext, createAggregator, (single, aggregagor) -> aggregagor.addChannel(single, logger));
        this.outputNameDefault = outputName;
    }

    @Override
    protected void outputGroupIntoSubdirectory(Collection<Map.Entry<String, T>> namedAggregators, Function<Boolean, InputOutputContext> createContext, Optional<String> outputNameSingle) throws IOException {
        Optional channelsMap = OutputChannelsAsRGB.canOutputAsRGB(namedAggregators);
        if (channelsMap.isPresent()) {
            OutputChannelsAsRGB.output((CheckedFunction<String, Channel, OperationFailedException>)((CheckedFunction)name -> ((ChannelAggregator)((Map)channelsMap.get()).get(name)).aggregatedChannel()), createContext.apply(false), this.resolveOutputName(outputNameSingle));
        } else {
            OutputChannelsSeparately.output(namedAggregators, () -> this.resolveOutputName(outputNameSingle), createContext);
        }
    }

    private String resolveOutputName(Optional<String> outputName) {
        return outputName.orElse(this.outputNameDefault);
    }
}

