/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.RGBChannelNames;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.io.stack.output.generator.StackGenerator;
import org.anchoranalysis.io.output.outputter.InputOutputContext;

class OutputChannelsAsRGB {
    public static <T> Optional<Map<String, T>> canOutputAsRGB(Collection<Map.Entry<String, T>> namedElements) {
        if (namedElements.size() == 3 || namedElements.size() == 4) {
            Map<String, Object> channelsMap = namedElements.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (RGBChannelNames.isValidNameSet(channelsMap.keySet(), (boolean)false) || RGBChannelNames.isValidNameSet(channelsMap.keySet(), (boolean)true)) {
                return Optional.of(channelsMap);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static void output(CheckedFunction<String, Channel, OperationFailedException> channelSupplier, InputOutputContext context, String outputName) throws IOException {
        try {
            RGBStack stack = new RGBStack((Channel)channelSupplier.apply((Object)"red"), (Channel)channelSupplier.apply((Object)"green"), (Channel)channelSupplier.apply((Object)"blue"));
            context.getOutputter().writerPermissive().write(outputName, () -> new StackGenerator(true), () -> ((RGBStack)stack).asStack());
        }
        catch (OperationFailedException e) {
            throw new IOException("Unable to extract a particular color channel to output an aggregate as a RGB", e);
        }
        catch (IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    private OutputChannelsAsRGB() {
    }
}

