/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.HasFriendlyErrorMessage;
import org.anchoranalysis.image.bean.channel.ChannelAggregator;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.io.channel.output.ChannelGenerator;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;

class OutputChannelsSeparately {
    public static <T extends ChannelAggregator> void output(Collection<Map.Entry<String, T>> namedAggregators, Supplier<String> outputNameSingle, Function<Boolean, InputOutputContext> createContext) {
        if (namedAggregators.size() > 1) {
            InputOutputContext context = createContext.apply(true);
            OutputChannelsSeparately.outputIntoContext(namedAggregators, Optional.empty(), context);
        } else {
            InputOutputContext context = createContext.apply(false);
            OutputChannelsSeparately.outputIntoContext(namedAggregators, Optional.of(outputNameSingle.get()), context);
        }
    }

    private static <T extends ChannelAggregator> void outputIntoContext(Collection<Map.Entry<String, T>> namedAggregators, Optional<String> outputName, InputOutputContext context) {
        namedAggregators.parallelStream().forEach(entry -> OutputChannelsSeparately.writeChannel(outputName.orElse((String)entry.getKey()), (ChannelAggregator)entry.getValue(), context));
    }

    private static <T extends ChannelAggregator> void writeChannel(String outputName, T aggregator, InputOutputContext context) {
        context.getOutputter().writerSecondLevel(outputName).write(outputName, ChannelGenerator::new, () -> OutputChannelsSeparately.extractChannel(aggregator));
    }

    private static <T extends ChannelAggregator> Channel extractChannel(T aggregator) throws OutputWriteFailedException {
        try {
            return aggregator.aggregatedChannel();
        }
        catch (OperationFailedException e) {
            throw new OutputWriteFailedException("Failed to create aggregated channel", (HasFriendlyErrorMessage)e);
        }
    }

    private OutputChannelsSeparately() {
    }
}

