/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.fill.Fill;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.spatial.scale.ScaleFactor;

class VaryingImageSizeArranger {
    private final int defaultWidth;
    private final double defaultWidthRatio;

    public StackArranger create(int numberRows, Optional<ImageSizeSuggestion> suggestion, boolean varyImageLocation) throws OperationFailedException {
        Fill fill = new Fill();
        fill.setNumberRows(numberRows);
        this.assignWidthToFill(fill, suggestion);
        fill.setVaryNumberImagesPerRow(varyImageLocation);
        return fill;
    }

    private void assignWidthToFill(Fill fill, Optional<ImageSizeSuggestion> suggestion) throws OperationFailedException {
        if (suggestion.isPresent()) {
            VaryingImageSizeArranger.assignWithToFillWithSuggestion(fill, suggestion.get());
        } else {
            fill.setWidthRatio(this.defaultWidthRatio);
            fill.setWidth(this.defaultWidth);
        }
    }

    private static void assignWithToFillWithSuggestion(Fill fill, ImageSizeSuggestion suggestion) throws OperationFailedException {
        Optional uniformScaling = suggestion.uniformScaleFactor();
        if (uniformScaling.isPresent()) {
            fill.setWidthRatio(((ScaleFactor)uniformScaling.get()).x());
            fill.setWidth(0);
            return;
        }
        Optional uniformWidth = suggestion.uniformWidth();
        if (!uniformWidth.isPresent() || suggestion.uniformHeight().isPresent()) {
            throw new OperationFailedException("An invalid resize suggestion was specified for this mode. It must be either a constant scale-factor or a specific width: e.g. 0.5 or 1000x");
        }
        fill.setWidth(((Integer)uniformWidth.get()).intValue());
        fill.setWidthRatio(0.0);
    }

    public VaryingImageSizeArranger(int defaultWidth, double defaultWidthRatio) {
        this.defaultWidth = defaultWidth;
        this.defaultWidthRatio = defaultWidthRatio;
    }
}

