/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.feature.source;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.HistogramProvider;
import org.anchoranalysis.image.feature.input.FeatureInputHistogram;
import org.anchoranalysis.image.io.ImageInitializationFactory;
import org.anchoranalysis.image.io.histogram.input.HistogramCSVReader;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.file.FileInput;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.task.bean.feature.source.SingleRowPerInput;
import org.anchoranalysis.plugin.image.task.feature.FeatureCalculationContext;
import org.anchoranalysis.plugin.image.task.feature.ResultsVectorWithThumbnail;

public class FromHistogram
extends SingleRowPerInput<FileInput, FeatureInputHistogram> {
    private static final String HISTOGRAM_INPUT_NAME_IN_PROVIDER = "input";
    @BeanField
    @OptionalBean
    private HistogramProvider histogram;

    public FromHistogram() {
        super("histogram");
    }

    @Override
    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(FileInput.class);
    }

    @Override
    public boolean includeGroupInExperiment(boolean groupGeneratorDefined) {
        return groupGeneratorDefined;
    }

    @Override
    protected ResultsVectorWithThumbnail calculateResultsForInput(FileInput input, FeatureCalculationContext<FeatureList<FeatureInputHistogram>> context) throws NamedFeatureCalculateException {
        return new ResultsVectorWithThumbnail((CheckedSupplier<ResultsVector, OperationFailedException>)((CheckedSupplier)() -> this.calculateFeature(input, context)));
    }

    private ResultsVector calculateFeature(FileInput input, FeatureCalculationContext<FeatureList<FeatureInputHistogram>> context) throws OperationFailedException {
        try {
            Histogram histogramRead = FromHistogram.readHistogramFromCSV(input);
            if (this.histogram != null) {
                histogramRead = this.filterHistogramFromProvider(histogramRead, context.getContext());
            }
            return FromHistogram.createCalculator(context.getFeatureSource(), context.getModelDirectory(), context.getLogger()).calculate((FeatureInput)new FeatureInputHistogram(histogramRead, Optional.empty()));
        }
        catch (BeanDuplicateException | InitializeException | OperationFailedException | NamedFeatureCalculateException | CSVReaderException e) {
            throw new OperationFailedException(e);
        }
    }

    private Histogram filterHistogramFromProvider(Histogram inputtedHistogram, InputOutputContext context) throws OperationFailedException {
        HistogramProvider providerDuplicated = (HistogramProvider)this.histogram.duplicateBean();
        try {
            providerDuplicated.initializeRecursive((BeanInitialization)this.createImageInitialization(inputtedHistogram, context), context.getLogger());
            return (Histogram)providerDuplicated.get();
        }
        catch (ProvisionFailedException | InitializeException | OperationFailedException e) {
            throw new OperationFailedException("Cannot retrieve a histogram from the provider", e);
        }
    }

    private ImageInitialization createImageInitialization(Histogram inputtedHist, InputOutputContext context) throws OperationFailedException {
        ImageInitialization initialization = ImageInitializationFactory.create((InputOutputContext)context);
        initialization.histograms().add(HISTOGRAM_INPUT_NAME_IN_PROVIDER, () -> inputtedHist);
        return initialization;
    }

    private static FeatureCalculatorMulti<FeatureInputHistogram> createCalculator(FeatureList<FeatureInputHistogram> features, Path modelDirectory, Logger logger) throws InitializeException {
        return FeatureSession.with(features, (FeatureInitialization)new FeatureInitialization(), (SharedFeatures)FeatureRelatedInitialization.create((Logger)logger, (Path)modelDirectory).getSharedFeatures(), (Logger)logger);
    }

    private static Histogram readHistogramFromCSV(FileInput input) throws CSVReaderException {
        File file = input.getFile();
        if (NonImageFileFormat.CSV.matches(file.getName())) {
            return HistogramCSVReader.readHistogramFromFile((Path)file.toPath());
        }
        throw new CSVReaderException("This task expects a CSV file encoding a histogram as input. The file path must end with " + NonImageFileFormat.CSV.extensionWithPeriod());
    }

    @Override
    protected Optional<String[]> additionalLabelsFor(FileInput input) {
        return Optional.empty();
    }

    public HistogramProvider getHistogram() {
        return this.histogram;
    }

    public void setHistogram(HistogramProvider histogram) {
        this.histogram = histogram;
    }
}

