/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.feature.source;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.io.csv.metadata.LabelHeaders;
import org.anchoranalysis.feature.io.csv.metadata.RowLabels;
import org.anchoranalysis.feature.io.name.SimpleName;
import org.anchoranalysis.feature.io.results.FeatureOutputNames;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.grouper.InputGrouper;
import org.anchoranalysis.plugin.image.task.bean.feature.source.FeatureSource;
import org.anchoranalysis.plugin.image.task.feature.FeatureCalculationContext;
import org.anchoranalysis.plugin.image.task.feature.FeatureExporter;
import org.anchoranalysis.plugin.image.task.feature.FeatureExporterContext;
import org.anchoranalysis.plugin.image.task.feature.LabelHeadersForCSV;
import org.anchoranalysis.plugin.image.task.feature.LabelledResultsVectorWithThumbnail;
import org.anchoranalysis.plugin.image.task.feature.ResultsVectorWithThumbnail;

public abstract class SingleRowPerInput<T extends InputFromManager, S extends FeatureInput>
extends FeatureSource<T, FeatureList<S>, S> {
    private String[] nonGroupHeaders;

    protected SingleRowPerInput(String headerIdentifier) {
        this.nonGroupHeaders = new String[]{headerIdentifier};
    }

    @Override
    public FeatureExporter<FeatureList<S>> createExporter(LabelHeaders metadataHeaders, List<NamedBean<FeatureListProvider<S>>> features, FeatureOutputNames outputNames, Optional<InputGrouper> grouper, FeatureExporterContext context) throws CreateException {
        return FeatureExporter.create(features, metadataHeaders, outputNames, grouper, context);
    }

    @Override
    public LabelHeaders headers(boolean groupsEnabled) {
        return LabelHeadersForCSV.createHeaders(this.nonGroupHeaders, Optional.empty(), groupsEnabled);
    }

    @Override
    public void calculateAndOutput(T input, FeatureCalculationContext<FeatureList<S>> context) throws OperationFailedException {
        try {
            LabelledResultsVectorWithThumbnail labelledResults = this.calculateLabelledResults(input, context);
            context.getResults().add((CheckedSupplier<LabelledResultsVector, OperationFailedException>)((CheckedSupplier)labelledResults::withoutThumbnail), labelledResults.getResults().getThumbnail());
        }
        catch (BeanDuplicateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected abstract ResultsVectorWithThumbnail calculateResultsForInput(T var1, FeatureCalculationContext<FeatureList<S>> var2) throws NamedFeatureCalculateException;

    protected abstract Optional<String[]> additionalLabelsFor(T var1) throws OperationFailedException;

    private LabelledResultsVectorWithThumbnail calculateLabelledResults(T input, FeatureCalculationContext<FeatureList<S>> context) throws OperationFailedException {
        try {
            ResultsVectorWithThumbnail results = this.calculateResultsForInput(input, context);
            RowLabels labels = this.labelsFor(input, context.getGroupGeneratorName());
            return new LabelledResultsVectorWithThumbnail(labels, results);
        }
        catch (NamedFeatureCalculateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private RowLabels labelsFor(T input, Optional<String> groupGeneratorName) throws OperationFailedException {
        Optional<String[]> additionalLabels = this.additionalLabelsFor(input);
        String[] nonGroupLabels = SingleRowPerInput.combine(input.identifier(), additionalLabels);
        if (nonGroupLabels.length != this.nonGroupHeaders.length) {
            throw new OperationFailedException(String.format("There were %d non-group labels, when %d were expected.", nonGroupLabels.length, this.nonGroupHeaders.length));
        }
        return new RowLabels(Optional.of(nonGroupLabels), groupGeneratorName.map(SimpleName::new));
    }

    private static String[] combine(String identifier, Optional<String[]> others) {
        if (others.isPresent()) {
            String[] out = new String[others.get().length + 1];
            out[0] = identifier;
            System.arraycopy(others.get(), 0, out, 1, others.get().length);
            return out;
        }
        return new String[]{identifier};
    }

    public SingleRowPerInput(String[] nonGroupHeaders) {
        this.nonGroupHeaders = nonGroupHeaders;
    }
}

