/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.format.convertstyle;

import java.util.Optional;
import java.util.Set;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.plugin.image.task.bean.format.convertstyle.ChannelConvertStyle;
import org.anchoranalysis.plugin.image.task.stack.ChannelGetterForTimepoint;

public class IndependentChannels
extends ChannelConvertStyle {
    @BeanField
    private boolean ignoreMissingChannel = true;

    @Override
    public NamedStacks convert(Set<String> channelNames, ChannelGetterForTimepoint channelGetter, Logger logger) throws OperationFailedException {
        NamedStacks out = new NamedStacks();
        for (String key : channelNames) {
            this.convertChannel(key, channelGetter, logger).ifPresent(stack -> out.add(key, stack));
        }
        return out;
    }

    private Optional<Stack> convertChannel(String key, ChannelGetterForTimepoint channelGetter, Logger logger) throws OperationFailedException {
        try {
            Channel channel = channelGetter.getChannel(key, logger);
            return Optional.of(new Stack(channel));
        }
        catch (GetOperationFailedException e) {
            if (this.ignoreMissingChannel) {
                logger.messageLogger().logFormatted("Cannot open channel '%s'. Ignoring.", new Object[]{key});
                return Optional.empty();
            }
            throw new OperationFailedException(String.format("Cannot open channel '%s'.", key), (Throwable)e);
        }
    }

    public boolean isIgnoreMissingChannel() {
        return this.ignoreMissingChannel;
    }

    public void setIgnoreMissingChannel(boolean ignoreMissingChannel) {
        this.ignoreMissingChannel = ignoreMissingChannel;
    }
}

