/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.format.convertstyle;

import java.util.Set;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.RGBChannelNames;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.plugin.image.task.bean.format.convertstyle.ChannelConvertStyle;
import org.anchoranalysis.plugin.image.task.bean.format.convertstyle.IndependentChannels;
import org.anchoranalysis.plugin.image.task.stack.ChannelGetterForTimepoint;

public class RGBIfNamesMatch
extends ChannelConvertStyle {
    @BeanField
    @OptionalBean
    private ChannelConvertStyle fallback = new IndependentChannels();

    @Override
    public NamedStacks convert(Set<String> channelNames, ChannelGetterForTimepoint channelGetter, Logger logger) throws OperationFailedException {
        if (!RGBChannelNames.isValidNameSet(channelNames)) {
            if (this.fallback != null) {
                return this.fallback.convert(channelNames, channelGetter, logger);
            }
            throw new OperationFailedException("Cannot convert as its channels do not look like RGB");
        }
        NamedStacks out = new NamedStacks();
        try {
            Stack stack = RGBIfNamesMatch.createRGBStack(channelGetter, channelNames.size() == 4, logger);
            out.add("", stack);
        }
        catch (CreateException e) {
            throw new OperationFailedException("Incorrect image size", (Throwable)e);
        }
        return out;
    }

    private static Stack createRGBStack(ChannelGetterForTimepoint channelGetter, boolean includeAlpha, Logger logger) throws CreateException {
        Stack stackRearranged = new Stack(true);
        RGBIfNamesMatch.addChannelOrBlank("red", channelGetter, stackRearranged, logger);
        RGBIfNamesMatch.addChannelOrBlank("green", channelGetter, stackRearranged, logger);
        RGBIfNamesMatch.addChannelOrBlank("blue", channelGetter, stackRearranged, logger);
        if (includeAlpha) {
            RGBIfNamesMatch.addChannelOrBlank("alpha", channelGetter, stackRearranged, logger);
        }
        return stackRearranged;
    }

    private static void addChannelOrBlank(String channelName, ChannelGetterForTimepoint channelGetter, Stack stackRearranged, Logger logger) throws CreateException {
        try {
            if (channelGetter.hasChannel(channelName)) {
                stackRearranged.addChannel(channelGetter.getChannel(channelName, logger));
            } else {
                logger.messageLogger().logFormatted(String.format("Adding a blank channel for %s", channelName), new Object[0]);
                stackRearranged.addBlankChannel();
            }
        }
        catch (OperationFailedException | GetOperationFailedException | IncorrectImageSizeException e) {
            throw new CreateException(e);
        }
    }

    public ChannelConvertStyle getFallback() {
        return this.fallback;
    }

    public void setFallback(ChannelConvertStyle fallback) {
        this.fallback = fallback;
    }
}

