/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.grouped.histogram;

import java.util.Optional;
import java.util.stream.Stream;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedBiConsumer;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.nonbean.ConsistentChannelChecker;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.task.bean.grouped.GroupedStackBase;
import org.anchoranalysis.plugin.image.task.bean.grouped.histogram.GroupedHistogramMap;
import org.anchoranalysis.plugin.image.task.bean.grouped.histogram.GroupedHistogramWriter;
import org.anchoranalysis.plugin.image.task.bean.grouped.histogram.MaskExtracter;
import org.anchoranalysis.plugin.image.task.grouped.ChannelSource;
import org.anchoranalysis.plugin.image.task.grouped.GroupMapByName;

public class ExportImageHistograms
extends GroupedStackBase<Histogram, Histogram> {
    private static final String OUTPUT_HISTOGRAMS = "channels";
    private static final String OUTPUT_SUM = "sum";
    @BeanField
    @AllowEmpty
    private String channelMask = "";
    @BeanField
    private int maskValue = 255;
    @BeanField
    private boolean csvIgnoreZeros = false;

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_HISTOGRAMS, OUTPUT_SUM});
    }

    @Override
    protected GroupMapByName<Histogram, Histogram> createGroupMap(ConsistentChannelChecker channelChecker, Optional<Stream<String>> groupIdentifiers, Optional<InputOutputContext> outputContext, OperationContext operationContext) {
        int maxIntensityValue = (int)channelChecker.getVoxelDataType().maxValue();
        return new GroupedHistogramMap(this.createWriter(), groupIdentifiers, outputContext, maxIntensityValue);
    }

    @Override
    protected Optional<String> subdirectoryForGroupOutputs() {
        return Optional.of(OUTPUT_SUM);
    }

    @Override
    protected CheckedFunction<Channel, Histogram, CreateException> createChannelDeriver(ChannelSource source) throws OperationFailedException {
        Optional<Mask> mask = MaskExtracter.extractMask(source, this.channelMask, this.maskValue);
        return channel -> HistogramFromObjectsFactory.createFrom((Channel)channel, (Optional)mask);
    }

    @Override
    protected void processIndividual(String name, Histogram individual, boolean partOfGroup, CheckedBiConsumer<String, Histogram, OperationFailedException> consumeIndividual, InputOutputContext context) throws OperationFailedException {
        this.createWriter().writeHistogramToFile(individual, name, context);
        consumeIndividual.accept((Object)name, (Object)individual);
    }

    @Override
    protected String outputNameForGroups() {
        return OUTPUT_SUM;
    }

    private GroupedHistogramWriter createWriter() {
        return new GroupedHistogramWriter(OUTPUT_HISTOGRAMS, this.csvIgnoreZeros);
    }

    public String getChannelMask() {
        return this.channelMask;
    }

    public void setChannelMask(String channelMask) {
        this.channelMask = channelMask;
    }

    public int getMaskValue() {
        return this.maskValue;
    }

    public void setMaskValue(int maskValue) {
        this.maskValue = maskValue;
    }

    public boolean isCsvIgnoreZeros() {
        return this.csvIgnoreZeros;
    }

    public void setCsvIgnoreZeros(boolean csvIgnoreZeros) {
        this.csvIgnoreZeros = csvIgnoreZeros;
    }
}

