/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.grouped.histogram;

import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.plugin.image.task.grouped.ChannelSource;

class MaskExtracter {
    public static Optional<Mask> extractMask(ChannelSource source, String maskStackName, int maskValue) throws OperationFailedException {
        if (!maskStackName.isEmpty()) {
            Channel extracted = source.extractChannel(maskStackName, false);
            return Optional.of(new Mask(extracted, MaskExtracter.createMaskBinaryValues(maskValue)));
        }
        return Optional.empty();
    }

    private static BinaryValuesInt createMaskBinaryValues(int maskValue) throws OperationFailedException {
        if (maskValue == 255) {
            return new BinaryValuesInt(0, 255);
        }
        if (maskValue == 0) {
            return new BinaryValuesInt(255, 0);
        }
        throw new OperationFailedException("Only mask-values of 255 or 0 are current supported");
    }

    private MaskExtracter() {
    }
}

