/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.labeller;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.NonEmpty;
import org.anchoranalysis.bean.annotation.SkipInit;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.experiment.task.NoSharedState;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.bean.labeller.BinaryOutcomeImageLabeller;
import org.anchoranalysis.plugin.image.task.feature.calculator.FeatureCalculatorFromProvider;

public class BinaryClassifierImageLabeller
extends BinaryOutcomeImageLabeller {
    @BeanField
    @SkipInit
    private FeatureListProvider<FeatureInputStack> classifierProvider;
    @BeanField
    @NonEmpty
    private List<NamedBean<FeatureListProvider<FeatureInputStack>>> listFeatures = new ArrayList<NamedBean<FeatureListProvider<FeatureInputStack>>>(0);
    @BeanField
    private StackProvider stackEnergy;

    @Override
    public String labelFor(NoSharedState sharedState, ProvidesStackInput input, InputOutputContext context) throws OperationFailedException {
        try {
            FeatureCalculatorFromProvider<FeatureInputStack> featureCalculator = new FeatureCalculatorFromProvider<FeatureInputStack>(input, Optional.of(this.getStackEnergy()), context);
            double classificationValue = featureCalculator.calculatorSingleFromProvider(this.classifierProvider, "classifierProvider").calculate((FeatureInput)new FeatureInputStack());
            context.getMessageReporter().logFormatted("Classification value = %f", new Object[]{classificationValue});
            return BinaryClassifierImageLabeller.classificationString(classificationValue >= 0.0);
        }
        catch (FeatureCalculationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public FeatureListProvider<FeatureInputStack> getClassifierProvider() {
        return this.classifierProvider;
    }

    public void setClassifierProvider(FeatureListProvider<FeatureInputStack> classifierProvider) {
        this.classifierProvider = classifierProvider;
    }

    public List<NamedBean<FeatureListProvider<FeatureInputStack>>> getListFeatures() {
        return this.listFeatures;
    }

    public void setListFeatures(List<NamedBean<FeatureListProvider<FeatureInputStack>>> listFeatures) {
        this.listFeatures = listFeatures;
    }

    public StackProvider getStackEnergy() {
        return this.stackEnergy;
    }

    public void setStackEnergy(StackProvider stackEnergy) {
        this.stackEnergy = stackEnergy;
    }
}

