/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.labeller;

import java.nio.file.Path;
import java.util.Set;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.bean.labeller.ImageLabeller;
import org.anchoranalysis.plugin.image.task.labeller.FileLabelMap;
import org.anchoranalysis.plugin.image.task.labeller.ImageCSVLabellerInitialization;

public class ImageCSVLabeller
extends ImageLabeller<ImageCSVLabellerInitialization> {
    @BeanField
    private DerivePath pathLabel;

    @Override
    public ImageCSVLabellerInitialization initialize(Path pathForBinding) throws InitializeException {
        try {
            Path csvPath = this.pathLabel.deriveFrom(pathForBinding, false);
            return new ImageCSVLabellerInitialization(FileLabelMap.readFromCSV(csvPath, false));
        }
        catch (CSVReaderException | DerivePathException e) {
            throw new InitializeException(e);
        }
    }

    @Override
    public Set<String> allLabels(ImageCSVLabellerInitialization initialization) {
        return initialization.getLabelMap().labels();
    }

    @Override
    public String labelFor(ImageCSVLabellerInitialization sharedState, ProvidesStackInput input, InputOutputContext context) throws OperationFailedException {
        String label = sharedState.getLabelMap().get(input.identifier());
        if (label == null) {
            throw new OperationFailedException(String.format("No label can be found for the name: %s", input.identifier()));
        }
        return label;
    }

    public DerivePath getPathLabel() {
        return this.pathLabel;
    }

    public void setPathLabel(DerivePath pathLabel) {
        this.pathLabel = pathLabel;
    }
}

