/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.scale;

import java.util.List;
import java.util.function.Function;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.plugin.image.task.size.SizeMapping;
import org.anchoranalysis.spatial.box.Extent;

class DeriveCommonSize {
    public static Extent scaleAndFindMax(List<SizeMapping> mappings, CheckedFunction<SizeMapping, SizeMapping, OperationFailedException> scaler) throws OperationFailedException {
        List<SizeMapping> scaled = DeriveCommonSize.scaleSizes(mappings, scaler);
        return DeriveCommonSize.deriveMaxSize(scaled);
    }

    private static List<SizeMapping> scaleSizes(List<SizeMapping> sizes, CheckedFunction<SizeMapping, SizeMapping, OperationFailedException> scaler) throws OperationFailedException {
        return FunctionalList.mapToList(sizes, OperationFailedException.class, mapping -> (SizeMapping)scaler.apply(mapping));
    }

    private static Extent deriveMaxSize(List<SizeMapping> mappings) throws OperationFailedException {
        return new Extent(DeriveCommonSize.maxSizeSingleDimension(mappings, Extent::x), DeriveCommonSize.maxSizeSingleDimension(mappings, Extent::y), DeriveCommonSize.maxSizeSingleDimension(mappings, Extent::z));
    }

    private static int maxSizeSingleDimension(List<SizeMapping> mappings, Function<Extent, Integer> extractDimension) {
        return mappings.stream().mapToInt(mapping -> (Integer)extractDimension.apply(mapping.getExtent())).max().orElse(0);
    }
}

