/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.scale;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.image.bean.spatial.arrange.align.Align;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.image.task.bean.scale.DeriveCommonSize;
import org.anchoranalysis.plugin.image.task.bean.scale.ScaleChannelHelper;
import org.anchoranalysis.plugin.image.task.bean.scale.ScaleImage;
import org.anchoranalysis.plugin.image.task.size.CommonSize;
import org.anchoranalysis.plugin.image.task.size.SizeMapping;
import org.anchoranalysis.plugin.image.task.stack.ImageSizePrereader;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.RelativeScaleCalculator;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class ScaleImageCommonSize
extends ScaleImage<CommonSize> {
    @DefaultInstance
    @BeanField
    private ImageMetadataReader imageMetadataReader;
    @DefaultInstance
    @BeanField
    private StackReader stackReader;
    @BeanField
    private Align align = new Align();
    @BeanField
    private int backgroundIntensity = 0;

    public CommonSize beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<StackSequenceInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        OperationContext context = parameters.getContext().operationContext();
        ImageSizePrereader prereader = new ImageSizePrereader(this.imageMetadataReader, this.stackReader, context);
        try {
            List<SizeMapping> imageSizes = prereader.imageSizesFor(inputs);
            Extent maxSize = DeriveCommonSize.scaleAndFindMax(imageSizes, (CheckedFunction<SizeMapping, SizeMapping, OperationFailedException>)((CheckedFunction)mapping -> this.scaleMapping((SizeMapping)mapping, parameters.deriveInitializationContext().getSuggestedSize())));
            return new CommonSize(maxSize);
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException("An error occurred scaling the image-sizes", (Throwable)e);
        }
    }

    @Override
    protected Stack scaleStack(Stack stack, Optional<ImageSizeSuggestion> suggestedSize, VoxelsResizer voxelsResizer, CommonSize sharedState) throws OperationFailedException {
        Stack scaled = this.scaleStack(stack, sharedState.extent(), voxelsResizer);
        if (scaled.dimensions().extent().equals((Object)sharedState.extent())) {
            return scaled;
        }
        return scaled.mapChannel(channel -> this.alignChannelInto((Channel)channel, sharedState.extent()));
    }

    private Channel alignChannelInto(Channel smaller, Extent commonSize) throws OperationFailedException {
        Dimensions dimensions = new Dimensions(commonSize, smaller.dimensions().resolution());
        Channel larger = ChannelFactory.instance().create(dimensions, smaller.getVoxelDataType());
        if (this.backgroundIntensity != 0) {
            larger.assignValue(this.backgroundIntensity);
        }
        BoundingBox box = this.align.align(smaller.extent(), larger.extent());
        smaller.voxels().copyVoxelsTo(new BoundingBox(smaller.extent()), larger.voxels(), box);
        return larger;
    }

    private SizeMapping scaleMapping(SizeMapping mapping, Optional<ImageSizeSuggestion> suggestedSize) throws OperationFailedException {
        ScaleFactor scaleFactor = this.scaleCalculator.calculate(Optional.of(new Dimensions(mapping.getExtent())), suggestedSize);
        return mapping.scaleXYBy(scaleFactor);
    }

    private Stack scaleStack(Stack stack, Extent maxSize, VoxelsResizer voxelsResizer) throws OperationFailedException {
        ScaleFactor scaleFactor = RelativeScaleCalculator.relativeScale((Extent)stack.dimensions().extent(), (Extent)maxSize, (boolean)true);
        return stack.mapChannel(channel -> ScaleImageCommonSize.scaleChannel(channel, this.binary, scaleFactor, voxelsResizer));
    }

    private static Channel scaleChannel(Channel channel, boolean binary, ScaleFactor scaleFactor, VoxelsResizer voxelsResizer) throws OperationFailedException {
        return ScaleChannelHelper.scaleChannel(channel, binary, scaleFactor, voxelsResizer);
    }

    public ImageMetadataReader getImageMetadataReader() {
        return this.imageMetadataReader;
    }

    public void setImageMetadataReader(ImageMetadataReader imageMetadataReader) {
        this.imageMetadataReader = imageMetadataReader;
    }

    public StackReader getStackReader() {
        return this.stackReader;
    }

    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public int getBackgroundIntensity() {
        return this.backgroundIntensity;
    }

    public void setBackgroundIntensity(int backgroundIntensity) {
        this.backgroundIntensity = backgroundIntensity;
    }
}

