/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.segment;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.io.csv.metadata.RowLabels;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.inference.segment.WithConfidence;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.inference.InferenceModel;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.CombineObjectsForFeatures;
import org.anchoranalysis.plugin.image.task.feature.InitializationWithEnergyStack;
import org.anchoranalysis.plugin.image.task.feature.calculator.CalculateFeaturesForObjects;
import org.anchoranalysis.plugin.image.task.segment.SharedStateSegmentInstance;

class FeatureCalculatorHelper {
    public static <T extends InferenceModel> void calculateFeaturesAndThumbnails(InputBound<StackSequenceInput, SharedStateSegmentInstance<T>> input, Stack stack, List<WithConfidence<ObjectMask>> segments, CombineObjectsForFeatures<FeatureInputSingleObject> combineObjects) throws OperationFailedException {
        if (segments.isEmpty()) {
            return;
        }
        EnergyStack energyStack = new EnergyStack(stack);
        ObjectCollection objects = FeatureCalculatorHelper.deriveObjects(segments);
        CalculateFeaturesForObjects<FeatureInputSingleObject> calculator = new CalculateFeaturesForObjects<FeatureInputSingleObject>(combineObjects, new InitializationWithEnergyStack(energyStack, input.createInitializationContext()), true, ((SharedStateSegmentInstance)input.getSharedState()).createCalculationContext(input.getContextJob().getExecutionTimeRecorder(), (InputOutputContext)input.getContextJob()));
        String imageIdentifier = ((StackSequenceInput)input.getInput()).identifier();
        input.getContextJob().getExecutionTimeRecorder().recordExecutionTime("Calculate for objects", () -> calculator.calculateForObjects(objects, energyStack, (instanceIdentifier, groupGeneratorName, index) -> FeatureCalculatorHelper.rowLabelsFor(imageIdentifier, instanceIdentifier, ((WithConfidence)segments.get(index)).getConfidence())));
    }

    private static RowLabels rowLabelsFor(String imageIdentifier, String instanceIdentifier, double confidence) {
        return new RowLabels(Optional.of(new String[]{imageIdentifier, instanceIdentifier, Double.toString(confidence)}), Optional.empty());
    }

    private static ObjectCollection deriveObjects(List<WithConfidence<ObjectMask>> objectsWithConfidence) {
        return new ObjectCollection(objectsWithConfidence.stream().map(WithConfidence::getElement));
    }

    private FeatureCalculatorHelper() {
    }
}

