/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.segment;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.feature.store.NamedFeatureStoreFactory;
import org.anchoranalysis.image.feature.bean.object.single.CenterOfGravity;
import org.anchoranalysis.image.feature.bean.object.single.NumberVoxels;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.EachObjectIndependently;
import org.anchoranalysis.spatial.axis.Axis;

class FeatureTableCreator {
    private static final NamedFeatureStoreFactory STORE_FACTORY = NamedFeatureStoreFactory.parametersOnly();

    public static FeatureTableCalculator<FeatureInputSingleObject> tableCalculator(Optional<List<NamedBean<FeatureListProvider<FeatureInputSingleObject>>>> features, EachObjectIndependently combineObjects) throws CreateException {
        if (features.isPresent()) {
            return combineObjects.createFeatures(features.get(), STORE_FACTORY, true);
        }
        return combineObjects.createFeatures(FeatureTableCreator.defaultInstanceSegmentation());
    }

    private static NamedFeatureStore<FeatureInputSingleObject> defaultInstanceSegmentation() {
        NamedFeatureStore store = new NamedFeatureStore();
        store.add("centerOfGravity.x", (Feature)new CenterOfGravity(Axis.X));
        store.add("centerOfGravity.y", (Feature)new CenterOfGravity(Axis.Y));
        store.add("centerOfGravity.z", (Feature)new CenterOfGravity(Axis.Z));
        store.add("numberVoxels", (Feature)new NumberVoxels());
        return store;
    }

    private FeatureTableCreator() {
    }
}

