/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.segment;

import java.awt.Color;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.shared.color.RGBColorBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.io.InitializationContext;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.io.csv.metadata.LabelHeaders;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.inference.bean.segment.instance.SegmentStackIntoObjectsPooled;
import org.anchoranalysis.image.inference.segment.SegmentedObjects;
import org.anchoranalysis.image.inference.segment.SegmentedObjectsAtScale;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.inference.InferenceModel;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.inference.concurrency.ConcurrentModelPool;
import org.anchoranalysis.inference.concurrency.CreateModelFailedException;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.CombineObjectsForFeatures;
import org.anchoranalysis.plugin.image.feature.bean.object.combine.EachObjectIndependently;
import org.anchoranalysis.plugin.image.task.bean.feature.ExportFeaturesStyle;
import org.anchoranalysis.plugin.image.task.bean.segment.FeatureCalculatorHelper;
import org.anchoranalysis.plugin.image.task.bean.segment.FeatureTableCreator;
import org.anchoranalysis.plugin.image.task.bean.segment.WriteSegmentationOutputsHelper;
import org.anchoranalysis.plugin.image.task.feature.FeatureExporterContext;
import org.anchoranalysis.plugin.image.task.segment.SharedStateSegmentInstance;
import org.anchoranalysis.plugin.image.task.stack.InitializationFactory;

public class SegmentInstanceWithModel<T extends InferenceModel>
extends Task<StackSequenceInput, SharedStateSegmentInstance<T>> {
    private static final String OUTPUT_SUMMARY_CSV = "summary";
    private static final String EXECUTION_TIME_OUTPUTS = "All outputs apart from thumbnails";
    private static final String EXECUTION_TIME_SEGMENTATION = "Segmentation";
    private static final String EXECUTION_TIME_FEATURES = "Calculating features + thumbnails";
    private static final String[] FEATURE_LABEL_HEADERS = new String[]{"image", "object", "confidence"};
    @BeanField
    private SegmentStackIntoObjectsPooled<T> segment;
    @BeanField
    @OptionalBean
    private RGBColorBean outlineColor = new RGBColorBean(Color.GREEN);
    @BeanField
    private boolean varyColors = false;
    @BeanField
    private int outlineWidth = 1;
    @BeanField
    @OptionalBean
    private List<NamedBean<FeatureListProvider<FeatureInputSingleObject>>> features;
    @BeanField
    private boolean ignoreNoObjects = false;
    @BeanField
    ExportFeaturesStyle style = new ExportFeaturesStyle();
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;
    private EachObjectIndependently combineObjects;

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(StackSequenceInput.class);
    }

    public SharedStateSegmentInstance<T> beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan plan, List<StackSequenceInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            this.initializeBeans(parameters.deriveInitializationContext());
            ConcurrentModelPool modelPool = this.segment.createModelPool(plan, parameters.getContext().getLogger());
            LabelHeaders headers = new LabelHeaders(FEATURE_LABEL_HEADERS);
            FeatureExporterContext context = this.style.deriveContext((InputOutputContext)parameters.getContext());
            FeatureTableCalculator<FeatureInputSingleObject> tableCalculator = FeatureTableCreator.tableCalculator(Optional.ofNullable(this.features), this.combineObjects());
            return new SharedStateSegmentInstance(modelPool, tableCalculator, headers, OUTPUT_SUMMARY_CSV, context);
        }
        catch (CreateException | InitializeException | CreateModelFailedException e) {
            throw new ExperimentExecutionException(e);
        }
    }

    public void doJobOnInput(InputBound<StackSequenceInput, SharedStateSegmentInstance<T>> input) throws JobExecutionException {
        try {
            this.initializeBeans(input.createInitializationContext());
            Stack stack = SegmentInstanceWithModel.inputStack(input);
            ExecutionTimeRecorder recorder = input.getContextExperiment().getExecutionTimeRecorder();
            SegmentedObjects segments = (SegmentedObjects)recorder.recordExecutionTime(EXECUTION_TIME_SEGMENTATION, () -> this.segment.segment(stack, ((SharedStateSegmentInstance)input.getSharedState()).getModelPool(), input.getContextExperiment().getExecutionTimeRecorder()));
            if (!segments.isEmpty() || !this.ignoreNoObjects) {
                recorder.recordExecutionTime(EXECUTION_TIME_OUTPUTS, () -> new WriteSegmentationOutputsHelper(this.varyColors, this.outlineWidth, this.outlineColor).writeOutputsForImage(stack, segments, input.getContextJob().getOutputter()));
                recorder.recordExecutionTime(EXECUTION_TIME_FEATURES, () -> FeatureCalculatorHelper.calculateFeaturesAndThumbnails(input, stack, ((SegmentedObjectsAtScale)segments.getObjects().atInputScale()).listWithoutLabels(), (CombineObjectsForFeatures<FeatureInputSingleObject>)this.combineObjects()));
            }
        }
        catch (InitializeException | OperationFailedException | SegmentationFailedException e) {
            throw new JobExecutionException(e);
        }
    }

    public void afterAllJobsAreExecuted(SharedStateSegmentInstance<T> sharedState, InputOutputContext context) throws ExperimentExecutionException {
        try {
            sharedState.closeAndWriteOutputs(this.style);
            SegmentInstanceWithModel.closeModelPool(sharedState.getModelPool(), context.getErrorReporter());
        }
        catch (OutputWriteFailedException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{"mask", "outline", "thumbnails", OUTPUT_SUMMARY_CSV});
    }

    private void initializeBeans(InitializationContext context) throws InitializeException {
        ImageInitialization initialization = InitializationFactory.createWithoutStacks(context);
        this.segment.initializeRecursive((BeanInitialization)initialization, context.getLogger());
    }

    private EachObjectIndependently combineObjects() {
        if (this.combineObjects == null) {
            this.combineObjects = new EachObjectIndependently(this.interpolator);
        }
        return this.combineObjects;
    }

    private static Stack inputStack(InputBound<StackSequenceInput, ?> input) throws OperationFailedException {
        return (Stack)input.getContextJob().getExecutionTimeRecorder().recordExecutionTime("Reading input stacks", () -> {
            try {
                TimeSeries series = ((StackSequenceInput)input.getInput()).createStackSequenceForSeries(0, input.getLogger());
                return series.getFrame(0);
            }
            catch (ImageIOException e) {
                throw new OperationFailedException((Throwable)e);
            }
        });
    }

    private static void closeModelPool(ConcurrentModelPool<?> modelPool, ErrorReporter errorReporter) {
        try {
            modelPool.close();
        }
        catch (Exception e) {
            errorReporter.recordError(SegmentInstanceWithModel.class, "An error occurred closing the inference model", (Throwable)e);
        }
    }

    public SegmentStackIntoObjectsPooled<T> getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentStackIntoObjectsPooled<T> segment) {
        this.segment = segment;
    }

    public RGBColorBean getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(RGBColorBean outlineColor) {
        this.outlineColor = outlineColor;
    }

    public boolean isVaryColors() {
        return this.varyColors;
    }

    public void setVaryColors(boolean varyColors) {
        this.varyColors = varyColors;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    public List<NamedBean<FeatureListProvider<FeatureInputSingleObject>>> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<NamedBean<FeatureListProvider<FeatureInputSingleObject>>> features) {
        this.features = features;
    }

    public boolean isIgnoreNoObjects() {
        return this.ignoreNoObjects;
    }

    public void setIgnoreNoObjects(boolean ignoreNoObjects) {
        this.ignoreNoObjects = ignoreNoObjects;
    }

    public ExportFeaturesStyle getStyle() {
        return this.style;
    }

    public void setStyle(ExportFeaturesStyle style) {
        this.style = style;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

