/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.segment;

import org.anchoranalysis.bean.shared.color.RGBColorBean;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.segment.SegmentedObjects;
import org.anchoranalysis.image.inference.segment.SegmentedObjectsAtScale;
import org.anchoranalysis.image.io.object.output.grayscale.ObjectsMergedAsMaskGenerator;
import org.anchoranalysis.image.io.object.output.hdf5.HDF5ObjectsGenerator;
import org.anchoranalysis.image.io.object.output.rgb.DrawObjectsGenerator;
import org.anchoranalysis.image.io.stack.output.generator.StackGenerator;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.writer.WriterRouterErrors;

class WriteSegmentationOutputsHelper {
    static final String OUTPUT_INPUT_IMAGE = "input";
    static final String OUTPUT_H5 = "objects";
    static final String OUTPUT_MERGED_AS_MASK = "mask";
    static final String OUTPUT_OUTLINE = "outline";
    static final String OUTPUT_NAME_SCALED_SUFFIX = "InputScale";
    private final boolean varyColors;
    private final int outlineWidth;
    private final RGBColorBean outlineColor;

    public void writeOutputsForImage(Stack stack, SegmentedObjects segmentedObjects, Outputter outputter) {
        WriterRouterErrors writer = outputter.writerSelective();
        writer.write(OUTPUT_INPUT_IMAGE, () -> new StackGenerator(true, false), () -> stack);
        writer.write(OUTPUT_H5, HDF5ObjectsGenerator::new, () -> ((SegmentedObjectsAtScale)((SegmentedObjectsAtScale)segmentedObjects.getObjects().atInputScale())).objects());
        this.writeOuputsAtScale(writer, (SegmentedObjectsAtScale)segmentedObjects.getObjects().atInputScale(), OUTPUT_NAME_SCALED_SUFFIX);
        this.writeOuputsAtScale(writer, (SegmentedObjectsAtScale)segmentedObjects.getObjects().atModelScale(), "");
    }

    private void writeOuputsAtScale(WriterRouterErrors writer, SegmentedObjectsAtScale memoized, String outputNameSuffix) {
        writer.write(OUTPUT_MERGED_AS_MASK + outputNameSuffix, () -> new ObjectsMergedAsMaskGenerator(memoized.background().dimensions()), () -> ((SegmentedObjectsAtScale)memoized).objects());
        writer.write(OUTPUT_OUTLINE + outputNameSuffix, () -> this.outlineGenerator(memoized.size(), memoized.backgroundDisplayStack()), () -> ((SegmentedObjectsAtScale)memoized).objectsWithProperties());
    }

    private DrawObjectsGenerator outlineGenerator(int objectsSize, DisplayStack background) {
        if (this.varyColors) {
            return DrawObjectsGenerator.outlineVariedColors((int)objectsSize, (int)this.outlineWidth, (DisplayStack)background);
        }
        return DrawObjectsGenerator.outlineSingleColor((int)this.outlineWidth, (DisplayStack)background, (RGBColor)this.outlineColor.toRGBColor());
    }

    public WriteSegmentationOutputsHelper(boolean varyColors, int outlineWidth, RGBColorBean outlineColor) {
        this.varyColors = varyColors;
        this.outlineWidth = outlineWidth;
        this.outlineColor = outlineColor;
    }
}

