/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.slice;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.SkipInit;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.image.io.stack.output.NamedStacksOutputter;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.plugin.image.task.bean.slice.ArraySearchUtilities;
import org.anchoranalysis.plugin.image.task.feature.calculator.FeatureCalculatorRepeated;
import org.anchoranalysis.plugin.image.task.stack.SharedStateSelectedSlice;

public class ExtractSlice
extends Task<NamedChannelsInput, SharedStateSelectedSlice> {
    private static final String OUTPUT_SLICES = "slices";
    @BeanField
    @SkipInit
    private FeatureListProvider<FeatureInputStack> scoreProvider;
    @BeanField
    private StackProvider stackEnergy;
    @BeanField
    private boolean findMaxima = true;

    public SharedStateSelectedSlice beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<NamedChannelsInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            return new SharedStateSelectedSlice(outputter);
        }
        catch (CreateException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(NamedChannelsInput.class);
    }

    public void doJobOnInput(InputBound<NamedChannelsInput, SharedStateSelectedSlice> input) throws JobExecutionException {
        try {
            EnergyStack energyStack = FeatureCalculatorRepeated.extractStack((ProvidesStackInput)input.getInput(), this.stackEnergy, (InputOutputContext)input.getContextJob());
            int optimaSliceIndex = this.selectSlice(energyStack, input.getLogger(), ((NamedChannelsInput)input.getInput()).identifier(), (SharedStateSelectedSlice)input.getSharedState());
            this.deriveSlicesAndOutput((NamedChannelsInput)input.getInput(), energyStack, optimaSliceIndex, input.getOutputter().getChecked(), input.getContextJob().getLogger());
        }
        catch (OperationFailedException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    public void afterAllJobsAreExecuted(SharedStateSelectedSlice sharedState, InputOutputContext context) throws ExperimentExecutionException {
        sharedState.close();
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_SLICES});
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    private int selectSlice(EnergyStack energyStack, Logger logger, String imageName, SharedStateSelectedSlice sharedState) throws OperationFailedException {
        Feature<FeatureInputStack> scoreFeature = this.extractScoreFeature();
        try {
            double[] scores = this.calculateScoreForEachSlice(scoreFeature, energyStack, logger);
            int optimalSliceIndex = this.findOptimalSlice(scores);
            logger.messageLogger().logFormatted("Selected optima is slice %d", new Object[]{optimalSliceIndex});
            sharedState.writeRow(imageName, optimalSliceIndex, scores[optimalSliceIndex]);
            return optimalSliceIndex;
        }
        catch (FeatureCalculationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void deriveSlicesAndOutput(NamedChannelsInput input, EnergyStack energyStack, int optimaSliceIndex, OutputterChecked outputter, Logger logger) throws OperationFailedException {
        NamedStacks stacks = ExtractSlice.collectionFromInput(input, logger);
        NamedStacks slices = stacks.applyOperation(stack -> stack.extractSlice(optimaSliceIndex), Optional.of(energyStack.dimensions()));
        try {
            NamedStacksOutputter.output((NamedProvider)slices, (String)OUTPUT_SLICES, (boolean)false, (OutputterChecked)outputter);
        }
        catch (OutputWriteFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static NamedStacks collectionFromInput(NamedChannelsInput input, Logger logger) throws OperationFailedException {
        NamedStacks stackCollection = new NamedStacks();
        input.addToStoreInferNames((NamedProviderStore)stackCollection, logger);
        return stackCollection;
    }

    private int findOptimalSlice(double[] scores) {
        if (this.findMaxima) {
            return ArraySearchUtilities.findIndexOfMaximum(scores);
        }
        return ArraySearchUtilities.findIndexOfMinimum(scores);
    }

    private double[] calculateScoreForEachSlice(Feature<FeatureInputStack> scoreFeature, EnergyStack energyStack, Logger logger) throws FeatureCalculationException {
        try {
            FeatureCalculatorSingle session = FeatureSession.with(scoreFeature, (Logger)logger);
            double[] results = new double[energyStack.dimensions().z()];
            for (int z = 0; z < energyStack.dimensions().z(); ++z) {
                EnergyStack energyStackSlice = energyStack.extractSlice(z);
                double featVal = session.calculate((FeatureInput)new FeatureInputStack(energyStackSlice.withoutParameters()));
                logger.messageLogger().logFormatted("Slice %3d has score %f", new Object[]{z, featVal});
                results[z] = featVal;
            }
            return results;
        }
        catch (InitializeException | OperationFailedException | FeatureCalculationException e) {
            throw new FeatureCalculationException(e);
        }
    }

    private Feature<FeatureInputStack> extractScoreFeature() throws OperationFailedException {
        try {
            FeatureList features = (FeatureList)this.scoreProvider.get();
            if (features.size() != 1) {
                throw new OperationFailedException(String.format("scoreProvider should return a list with exactly 1 feature, instead it has %d features.", features.size()));
            }
            return features.get(0);
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public FeatureListProvider<FeatureInputStack> getScoreProvider() {
        return this.scoreProvider;
    }

    public void setScoreProvider(FeatureListProvider<FeatureInputStack> scoreProvider) {
        this.scoreProvider = scoreProvider;
    }

    public StackProvider getStackEnergy() {
        return this.stackEnergy;
    }

    public void setStackEnergy(StackProvider stackEnergy) {
        this.stackEnergy = stackEnergy;
    }

    public boolean isFindMaxima() {
        return this.findMaxima;
    }

    public void setFindMaxima(boolean findMaxima) {
        this.findMaxima = findMaxima;
    }
}

