/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.channel.aggregator;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedBufferAsInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

class VoxelwiseArithmetic {
    public static void divide(Voxels<UnsignedIntBuffer> voxels, int count, VoxelsUntyped out) throws OperationFailedException {
        VoxelDataType outputType = out.getVoxelDataType();
        if (outputType.equals((Object)UnsignedShortVoxelType.INSTANCE)) {
            VoxelwiseArithmetic.divideValue(voxels, count, out.asShort());
        } else if (outputType.equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            VoxelwiseArithmetic.divideValue(voxels, count, out.asByte());
        } else {
            VoxelwiseArithmetic.throwUnsupportedDataTypeException(outputType);
        }
    }

    public static void add(Voxels<UnsignedIntBuffer> voxels, VoxelsUntyped toAdd) throws OperationFailedException {
        VoxelDataType toAddType = toAdd.getVoxelDataType();
        if (toAddType.equals((Object)UnsignedShortVoxelType.INSTANCE)) {
            VoxelwiseArithmetic.add(voxels, toAdd.asShort());
        } else if (toAddType.equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            VoxelwiseArithmetic.add(voxels, toAdd.asByte());
        } else {
            VoxelwiseArithmetic.throwUnsupportedDataTypeException(toAddType);
        }
    }

    private static <T extends UnsignedBufferAsInt> void add(Voxels<UnsignedIntBuffer> voxels, Voxels<T> toAdd) {
        toAdd.extent().iterateOverZ(z -> {
            UnsignedIntBuffer buffer1 = (UnsignedIntBuffer)voxels.sliceBuffer(z);
            UnsignedBufferAsInt buffer2 = (UnsignedBufferAsInt)toAdd.sliceBuffer(z);
            while (buffer1.hasRemaining()) {
                long sum = buffer1.getUnsigned() + (long)buffer2.getUnsigned();
                VoxelwiseArithmetic.oneStepBackward(buffer1);
                buffer1.putUnsigned(sum);
            }
        });
    }

    private static <T extends UnsignedBuffer> void divideValue(Voxels<UnsignedIntBuffer> in, int divideBy, Voxels<T> out) {
        in.extent().iterateOverZ(z -> {
            UnsignedIntBuffer bufferIn = (UnsignedIntBuffer)in.sliceBuffer(z);
            UnsignedBuffer bufferOut = (UnsignedBuffer)out.sliceBuffer(z);
            while (bufferIn.hasRemaining()) {
                bufferOut.putLong(bufferIn.getUnsigned() / (long)divideBy);
            }
        });
    }

    private static void oneStepBackward(UnsignedIntBuffer buffer) {
        buffer.position(buffer.position() - 1);
    }

    private static void throwUnsupportedDataTypeException(VoxelDataType voxelDataType) throws OperationFailedException {
        throw new OperationFailedException(String.format("Unsupported data type: %s", voxelDataType));
    }

    private VoxelwiseArithmetic() {
    }
}

