/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.feature.FeatureResultsAndThumbnails;

public class FeatureCalculationContext<S> {
    private final FeatureResultsAndThumbnails results;
    private final S featureSource;
    private final FeatureNameList featureNames;
    private final Optional<String> groupGeneratorName;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private final InputOutputContext context;
    private final boolean suppressErrors;
    private boolean thumbnailsEnabled;

    public FeatureCalculationContext(FeatureResultsAndThumbnails results, S rowSource, FeatureNameList featureNames, Optional<String> groupGeneratorName, ExecutionTimeRecorder executionTimeRecorder, boolean suppressErrors, InputOutputContext context) {
        this.results = results;
        this.featureSource = rowSource;
        this.featureNames = featureNames;
        this.groupGeneratorName = groupGeneratorName;
        this.executionTimeRecorder = executionTimeRecorder;
        this.suppressErrors = suppressErrors;
        this.context = context;
        this.thumbnailsEnabled = this.areThumbnailsEnabled(context);
    }

    public Path getModelDirectory() {
        return this.context.getModelDirectory();
    }

    public Logger getLogger() {
        return this.context.getLogger();
    }

    public OperationContext getOperationContext() {
        return this.context.operationContext();
    }

    private boolean areThumbnailsEnabled(InputOutputContext context) {
        return context.getOutputter().outputsEnabled().isOutputEnabled("thumbnails");
    }

    public FeatureResultsAndThumbnails getResults() {
        return this.results;
    }

    public S getFeatureSource() {
        return this.featureSource;
    }

    public FeatureNameList getFeatureNames() {
        return this.featureNames;
    }

    public Optional<String> getGroupGeneratorName() {
        return this.groupGeneratorName;
    }

    public ExecutionTimeRecorder getExecutionTimeRecorder() {
        return this.executionTimeRecorder;
    }

    public InputOutputContext getContext() {
        return this.context;
    }

    public boolean isSuppressErrors() {
        return this.suppressErrors;
    }

    public boolean isThumbnailsEnabled() {
        return this.thumbnailsEnabled;
    }
}

