/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature.calculator;

import java.util.Optional;
import org.anchoranalysis.core.cache.CachedSupplier;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.experiment.io.InitializationContext;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMultiChangeInput;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingleChangeInput;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.feature.calculator.ExtractFromProvider;
import org.anchoranalysis.plugin.image.task.stack.InitializationFactory;

public class FeatureCalculatorFromProvider<T extends FeatureInputEnergy> {
    private final ImageInitialization initialization;
    private final EnergyStack energyStack;
    private final Logger logger;

    public FeatureCalculatorFromProvider(ProvidesStackInput stackInput, Optional<StackProvider> stackEnergy, InputOutputContext context) throws OperationFailedException {
        this.initialization = (ImageInitialization)context.getExecutionTimeRecorder().recordExecutionTime("Creating image-initialization", () -> InitializationFactory.createWithStacks(stackInput, new InitializationContext(context)));
        CachedSupplier loadImage = CachedSupplier.cacheChecked(() -> FeatureCalculatorFromProvider.allStacksAsOne((NamedProviderStore<Stack>)this.initialization.stacks(), context.getExecutionTimeRecorder()));
        this.energyStack = (EnergyStack)context.getExecutionTimeRecorder().recordExecutionTime("Loading feature calculation stack", () -> this.energyStackFromProviderOrElse(stackEnergy, (CachedSupplier<Stack, OperationFailedException>)loadImage, context.getLogger()));
        this.logger = context.getLogger();
    }

    public FeatureCalculatorSingle<T> calculatorSingleFromProvider(FeatureListProvider<T> provider, String providerName) throws OperationFailedException {
        try {
            Feature<T> feature = ExtractFromProvider.extractFeature(provider, providerName, this.initialization.featuresInitialization(), this.logger);
            return this.createSingleCalculator(feature, this.initialization.featuresInitialization().getSharedFeatures());
        }
        catch (InitializeException | FeatureCalculationException e) {
            throw new OperationFailedException(e);
        }
    }

    public FeatureCalculatorMulti<T> calculatorForAll(FeatureList<T> features) throws InitializeException {
        return this.createMultiCalculator(features, this.initialization.featuresInitialization().getSharedFeatures());
    }

    private EnergyStack energyStackFromProviderOrElse(Optional<StackProvider> stackEnergy, CachedSupplier<Stack, OperationFailedException> fallback, Logger logger) throws OperationFailedException {
        if (stackEnergy.isPresent()) {
            return ExtractFromProvider.extractStack(stackEnergy.get(), this.initialization, logger);
        }
        return new EnergyStack((Stack)fallback.get());
    }

    private FeatureCalculatorMulti<T> createMultiCalculator(FeatureList<T> features, SharedFeatures sharedFeatures) throws InitializeException {
        return new FeatureCalculatorMultiChangeInput(FeatureSession.with(features, (FeatureInitialization)new FeatureInitialization(), (SharedFeatures)sharedFeatures, (Logger)this.logger), input -> input.setEnergyStack(this.energyStack));
    }

    private FeatureCalculatorSingle<T> createSingleCalculator(Feature<T> feature, SharedFeatures sharedFeatures) throws InitializeException {
        return new FeatureCalculatorSingleChangeInput(FeatureSession.with(feature, (FeatureInitialization)new FeatureInitialization(), (SharedFeatures)sharedFeatures, (Logger)this.logger), input -> input.setEnergyStack(this.energyStack));
    }

    private static Stack allStacksAsOne(NamedProviderStore<Stack> store, ExecutionTimeRecorder executionTimeRecorder) throws OperationFailedException {
        try {
            Stack out = new Stack();
            for (String key : store.keys()) {
                Stack channel = (Stack)executionTimeRecorder.recordExecutionTime("Loading channel", () -> (Stack)store.getOptional(key).get());
                out.addChannelsFrom(channel);
            }
            return out;
        }
        catch (NamedProviderGetException | IncorrectImageSizeException e) {
            throw new OperationFailedException(e);
        }
    }

    public EnergyStack getEnergyStack() {
        return this.energyStack;
    }
}

