/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.grouped;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.anchoranalysis.core.collection.MapCreate;
import org.anchoranalysis.core.collection.MapCreateCountdown;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedBiConsumer;
import org.anchoranalysis.core.functional.checked.CheckedConsumer;
import org.anchoranalysis.feature.io.name.MultiName;
import org.anchoranalysis.feature.io.name.MultiNameFactory;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.apache.commons.math3.util.Pair;

public abstract class GroupMapByName<S, T> {
    private final MapCreateCountdown<Optional<String>, MapCreate<String, T>> map = new MapCreateCountdown(() -> new MapCreate(createAggregator), (groupIdentifier, groupMap) -> this.outputGroup((Optional<String>)groupIdentifier, (MapCreate<String, T>)groupMap, outputContext));
    private final String nounT;
    private final CheckedBiConsumer<S, T, OperationFailedException> addSingleToAggregator;

    protected GroupMapByName(String nounT, Optional<Stream<String>> groupIdentifiers, Optional<InputOutputContext> outputContext, Supplier<T> createAggregator, CheckedBiConsumer<S, T, OperationFailedException> addSingleToAggregator) {
        if (groupIdentifiers.isPresent()) {
            groupIdentifiers.get().forEach(identifier -> this.map.increment(Optional.of(identifier)));
        } else {
            this.map.increment(Optional.empty());
        }
        this.nounT = nounT;
        this.addSingleToAggregator = addSingleToAggregator;
    }

    public synchronized void add(Optional<String> groupIdentifier, List<Pair<String, S>> singleItemsToAdd) throws OperationFailedException {
        CheckedConsumer operation = value -> this.addAllItemsToMap(groupIdentifier, (MapCreate<String, T>)value, singleItemsToAdd);
        if (groupIdentifier.isPresent()) {
            this.map.processElementDecrement(groupIdentifier, operation);
        } else {
            this.map.processElement(groupIdentifier, operation);
        }
    }

    public void outputAnyRemainingGroups() throws OperationFailedException {
        this.map.cleanUpRemaining();
    }

    protected abstract void outputGroupIntoSubdirectory(Collection<Map.Entry<String, T>> var1, Function<Boolean, InputOutputContext> var2, Optional<String> var3) throws IOException;

    private void addAllItemsToMap(Optional<String> groupIdentifier, MapCreate<String, T> map, List<Pair<String, S>> singleItemsToAdd) throws OperationFailedException {
        for (Pair<String, S> pair : singleItemsToAdd) {
            try {
                Object aggregator = map.computeIfAbsent((Object)((String)pair.getFirst()));
                this.addSingleToAggregator.accept(pair.getSecond(), aggregator);
            }
            catch (OperationFailedException e) {
                MultiName identifier = MultiNameFactory.create(groupIdentifier, (String)((String)pair.getFirst()));
                throw new OperationFailedException(String.format("An error occurred combining the %s created for: %s", this.nounT, identifier), (Throwable)e);
            }
        }
    }

    private void outputGroup(Optional<String> groupIdentifier, MapCreate<String, T> groupMap, Optional<InputOutputContext> outputContext) throws OperationFailedException {
        try {
            if (outputContext.isPresent()) {
                Set entries = groupMap.entrySet();
                this.outputGroupIntoSubdirectory(entries, multipleOutputs -> GroupMapByName.maybeCreateSubdirectory(multipleOutputs, (InputOutputContext)outputContext.get(), groupIdentifier), groupIdentifier);
            }
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static InputOutputContext maybeCreateSubdirectory(boolean multipleOutputs, InputOutputContext context, Optional<String> groupKey) {
        if (groupKey.isPresent() && multipleOutputs) {
            return context.subdirectory(groupKey.get(), false);
        }
        return context;
    }
}

