/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.labeller;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.anchoranalysis.io.input.csv.CSVReaderByLine;
import org.anchoranalysis.io.input.csv.CSVReaderException;
import org.anchoranalysis.io.input.csv.ReadByLine;

public class FileLabelMap<T> {
    private Map<T, String> map = new HashMap<T, String>();

    public static FileLabelMap<String> readFromCSV(Path csvPath, boolean quotedStrings) throws CSVReaderException {
        FileLabelMap<String> map = new FileLabelMap<String>();
        try (ReadByLine reader = CSVReaderByLine.open((Path)csvPath, (String)",", (boolean)true, (boolean)quotedStrings);){
            reader.read((line, firstLine) -> map.add(line[0], line[1]));
        }
        return map;
    }

    public void add(T fileId, String label) {
        this.map.put(fileId, label);
    }

    public String get(T fileId) {
        return this.map.get(fileId);
    }

    public Set<String> labels() {
        return new HashSet<String>(this.map.values());
    }

    public Set<Map.Entry<T, String>> entrySet() {
        return this.map.entrySet();
    }

    private FileLabelMap() {
    }
}

