/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.slice;

import ij.process.ImageProcessor;
import java.util.Comparator;
import java.util.stream.Stream;
import org.anchoranalysis.math.optimization.SearchClosestValueMonoticallyIncreasing;
import org.anchoranalysis.plugin.image.task.slice.LabelToWrite;
import org.anchoranalysis.spatial.point.Point2d;

class FontSizeCalculator {
    private static final int MINIMUM_FONT_SIZE = 12;
    private static final int MINIMUM_FONT_HEIGHT = 9;
    private static final String TEXT_HEIGHT_BOUNDS = "aBHAS12a1PP(";
    private final LabelToWrite labelWidthBounds;
    private final ImageProcessor processor;

    public FontSizeCalculator(ImageProcessor processor, Stream<LabelToWrite> labels) {
        this.processor = processor;
        this.labelWidthBounds = FontSizeCalculator.calculateLabelWithMaxWidthRatio(labels);
    }

    public int calculateOptimalFontSize(Point2d averageBoxSize, double ratioHeightForLabel) {
        double targetFontHeight = averageBoxSize.y() * ratioHeightForLabel;
        if (targetFontHeight > 9.0) {
            SearchClosestValueMonoticallyIncreasing search = new SearchClosestValueMonoticallyIncreasing(targetFontHeight, fontSize -> FontSizeCalculator.calculateStringHeight(fontSize, this.processor), fontSize -> this.calculateStringWidth(this.processor) > this.labelWidthBounds.getBoxImage().extent().x());
            return search.findOptimalInput(12);
        }
        return 12;
    }

    private int calculateStringWidth(ImageProcessor processor) {
        return processor.getStringWidth(this.labelWidthBounds.getText());
    }

    private static LabelToWrite calculateLabelWithMaxWidthRatio(Stream<LabelToWrite> labels) {
        return labels.max(Comparator.comparing(LabelToWrite::ratioNumberCharactersToWidth)).get();
    }

    private static double calculateStringHeight(int fontSize, ImageProcessor processor) {
        processor.setFontSize(fontSize);
        return processor.getStringBounds(TEXT_HEIGHT_BOUNDS).getHeight();
    }
}

