/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.slice;

import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

class LabelToWrite {
    private static final int MARGIN_PIXELS = 16;
    private String text;
    private BoundingBox boxImage;
    private BoundingBox boxText;
    private boolean errored;

    public LabelToWrite(String text, BoundingBox box, boolean errored) {
        this.boxImage = box;
        this.errored = errored;
        this.text = errored ? text + " (errored)" : text;
    }

    public void drawOnProcessor(ImageProcessor processor, Color backgroundSuccessful, Color backgroundErrored, BoxAligner aligner) throws OperationFailedException {
        BoundingBox textBox = this.calculateTextPosition(aligner, processor);
        processor.drawString(this.text, textBox.cornerMin().x(), textBox.calculateCornerMaxExclusive().y(), this.errored ? backgroundErrored : backgroundSuccessful);
    }

    public double ratioNumberCharactersToWidth() {
        return (double)this.text.length() / (double)this.boxImage.extent().x();
    }

    private BoundingBox calculateTextPosition(BoxAligner aligner, ImageProcessor processor) throws OperationFailedException {
        if (this.boxText == null) {
            Extent textSize = this.calculateSizeMaybeReduceText(processor);
            this.boxText = aligner.align(textSize, this.boxImage);
        }
        return this.boxText;
    }

    private Extent calculateSizeMaybeReduceText(ImageProcessor processor) {
        Extent textSize = LabelToWrite.calculateTextSize(this.text, processor);
        int maximumPermittedWidth = Math.max(this.boxImage.extent().x() - 16, 16);
        if (textSize.x() > maximumPermittedWidth) {
            double fractionToKeep = (double)maximumPermittedWidth / (double)textSize.x();
            int numberCharactersToKeep = Math.max((int)Math.floor((double)this.text.length() * fractionToKeep) - 3, 0);
            this.text = this.text.substring(0, numberCharactersToKeep) + "...";
            return LabelToWrite.calculateTextSize(this.text, processor);
        }
        return textSize;
    }

    private static Extent calculateTextSize(String text, ImageProcessor processor) {
        Rectangle bounds = processor.getStringBounds(text);
        int width = (int)Math.ceil(bounds.getWidth());
        int height = (int)Math.ceil(bounds.getHeight());
        return new Extent(width, height);
    }

    public String getText() {
        return this.text;
    }

    public BoundingBox getBoxImage() {
        return this.boxImage;
    }
}

