/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.slice;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.BoundingBoxEnclosed;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackCopierAtBox;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.plugin.image.task.slice.MontageLabels;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class MontageSharedState {
    private final MontageLabels labels;
    private final RGBStack stack;
    private final Map<Path, BoundingBoxEnclosed> boxes;
    private final VoxelsResizer resizer;

    public MontageSharedState(Map<Path, BoundingBoxEnclosed> boxes, Extent sizeCombined, VoxelsResizer resizer, ExecutionTimeRecorder executionTimeRecorder) {
        this.boxes = boxes;
        this.stack = new RGBStack(sizeCombined);
        this.resizer = resizer;
        this.labels = new MontageLabels(executionTimeRecorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStackInto(CheckedSupplier<RGBStack, InputReadFailedException> source, String identifier, Path path, Optional<String> label) throws JobExecutionException {
        BoundingBoxEnclosed box = this.boxes.get(path);
        if (box == null) {
            throw new JobExecutionException(String.format("An error occurred pre-reading the image size for %s so it is omitted from the montage.", identifier));
        }
        try {
            RGBStack sourceResized = ((RGBStack)source.get()).mapChannel(channel -> channel.resizeXY(box.getBox().extent(), this.resizer));
            MontageSharedState montageSharedState = this;
            synchronized (montageSharedState) {
                StackCopierAtBox.copyImageInto((Stack)sourceResized.asStack(), (Stack)this.stack.asStack(), (BoundingBox)box.getBox());
            }
            if (label.isPresent()) {
                this.labels.add(label.get(), box.getEnclosing(), false);
            }
        }
        catch (Exception e) {
            if (label.isPresent()) {
                this.labels.add(label.get(), box.getEnclosing(), true);
            }
            throw new JobExecutionException("An error occurred copying the input image into the montage: " + identifier, (Throwable)e);
        }
    }

    public void drawAllLabels(double ratioHeightForLabel, BoxAligner aligner) throws OperationFailedException {
        this.labels.flush(this.stack, ratioHeightForLabel, aligner);
    }

    public RGBStack getStack() {
        return this.stack;
    }
}

