/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.image.bean.spatial.arrange.tile.Tile;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.plugin.image.task.size.SizeMapping;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.ScaleFactor;

class FixedImageSizeArranger {
    private final ScaleCalculator fixedSizeScaler;
    private final BoxAligner aligner;

    public StackArranger create(int numberRows, Optional<ImageSizeSuggestion> suggestion, List<SizeMapping> imageSizes) throws OperationFailedException {
        this.scaleAllImages(imageSizes, suggestion);
        int numberColumns = FixedImageSizeArranger.calculateNumberColumns(imageSizes.size(), numberRows);
        Tile tile = new Tile();
        tile.setNumberColumns(numberColumns);
        tile.setNumberRows(numberRows);
        tile.setAligner(this.aligner);
        return tile;
    }

    private void scaleAllImages(List<SizeMapping> imageSizes, Optional<ImageSizeSuggestion> suggestion) throws OperationFailedException {
        Optional scaleFactor = OptionalUtilities.map(suggestion, FixedImageSizeArranger::extractScaleFactor);
        for (SizeMapping mapping : imageSizes) {
            this.scaleSizeMapping(mapping, scaleFactor);
        }
    }

    private void scaleSizeMapping(SizeMapping mapping, Optional<ScaleFactor> scaleFactor) {
        try {
            if (scaleFactor.isPresent()) {
                Extent second = mapping.getExtent().scaleXYBy(scaleFactor.get(), true);
                mapping.assignExtent(second);
            } else {
                Dimensions dimensions = new Dimensions(mapping.getExtent());
                ScaleFactor factor = this.fixedSizeScaler.calculate(Optional.of(dimensions), Optional.empty());
                mapping.assignExtent(mapping.getExtent().scaleXYBy(factor, true));
            }
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    private static ScaleFactor extractScaleFactor(ImageSizeSuggestion suggestion) throws OperationFailedException {
        Optional factor = suggestion.uniformScaleFactor();
        return (ScaleFactor)factor.orElseThrow(() -> new OperationFailedException("Only a constant scaling-factor is supported for this operation. Scaling that resizes to a specific width or height is unsupported."));
    }

    private static int calculateNumberColumns(int totalNumberImages, int numberRows) {
        return (int)Math.ceil((double)totalNumberImages / (double)numberRows);
    }

    @Generated
    public FixedImageSizeArranger(ScaleCalculator fixedSizeScaler, BoxAligner aligner) {
        this.fixedSizeScaler = fixedSizeScaler;
        this.aligner = aligner;
    }
}

