/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.align.Align;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.image.bean.spatial.arrange.align.Grow;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.ConvertStackToRGB;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.image.io.stack.output.generator.StackGenerator;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.writer.WriterRouterErrors;
import org.anchoranalysis.plugin.image.bean.scale.ToDimensions;
import org.anchoranalysis.plugin.image.task.bean.combine.FixedImageSizeArranger;
import org.anchoranalysis.plugin.image.task.bean.combine.MontageSharedStateFactory;
import org.anchoranalysis.plugin.image.task.bean.combine.VaryingImageSizeArranger;
import org.anchoranalysis.plugin.image.task.size.SizeMapping;
import org.anchoranalysis.plugin.image.task.slice.MontageSharedState;
import org.anchoranalysis.plugin.image.task.stack.ImageSizePrereader;

public class Montage
extends Task<StackSequenceInput, MontageSharedState> {
    static final String OUTPUT_UNLABELLED = "unlabelled";
    static final String OUTPUT_LABELLED = "labelled";
    @DefaultInstance
    @BeanField
    private ImageMetadataReader imageMetadataReader;
    @DefaultInstance
    @BeanField
    private StackReader stackReader;
    @DefaultInstance
    @BeanField
    private Interpolator interpolator;
    @BeanField
    private boolean varyImageSize = true;
    @BeanField
    private boolean varyImageLocation = true;
    @BeanField
    private BoxAligner aligner = new Grow(true);
    @BeanField
    @Positive
    private double ratioHeightForLabel = 0.05;
    @BeanField
    private BoxAligner alignerLabel = new Align("center", "bottom", "bottom");
    @BeanField
    private ScaleCalculator fixedSizeScaler = new ToDimensions(600, 480, true);
    @BeanField
    private int varyingSizeWidth = 1024;
    @BeanField
    private double varyingSizeWidthRatio = 0.1;
    @BeanField
    private double ratioRowsToColumns = 1.0;
    @BeanField
    @DefaultInstance
    private StackDisplayer displayer;

    public MontageSharedState beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<StackSequenceInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        if (inputs.isEmpty()) {
            throw new ExperimentExecutionException("No inputs exist, so no montage can be created");
        }
        OperationContext context = parameters.getContext().operationContext();
        ImageSizePrereader prereader = new ImageSizePrereader(this.imageMetadataReader, this.stackReader, context);
        List<SizeMapping> imageSizes = prereader.imageSizesFor(inputs);
        try {
            StackArranger arranger = this.createArranger(imageSizes, parameters.getExecutionArguments().task().getSize());
            return MontageSharedStateFactory.create(imageSizes, arranger, this.interpolator.voxelsResizer(), context);
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException("An error occurred arranging the images in the montage", (Throwable)e);
        }
    }

    public void doJobOnInput(InputBound<StackSequenceInput, MontageSharedState> input) throws JobExecutionException {
        try {
            Optional stackLabel = OptionalFactory.create((boolean)this.labelsEnabled(input.getOutputter()), () -> ((StackSequenceInput)((StackSequenceInput)input.getInput())).identifier());
            Path path = ((StackSequenceInput)input.getInput()).pathForBindingRequired();
            input.getContextExperiment().getExecutionTimeRecorder().recordExecutionTime("Copy and scale stack into montage", () -> ((MontageSharedState)input.getSharedState()).copyStackInto((CheckedSupplier<RGBStack, InputReadFailedException>)((CheckedSupplier)() -> this.readStackFromInput(input)), ((StackSequenceInput)input.getInput()).identifier(), path, stackLabel));
        }
        catch (InputReadFailedException e) {
            throw new JobExecutionException(String.format("An error occurred copying the input image into the montage: %s", ((StackSequenceInput)input.getInput()).identifier()), (Throwable)e);
        }
    }

    public void afterAllJobsAreExecuted(MontageSharedState sharedState, InputOutputContext context) throws ExperimentExecutionException {
        this.writeMontage(context.getOutputter().writerSelective(), OUTPUT_UNLABELLED, sharedState);
        try {
            if (this.labelsEnabled(context.getOutputter())) {
                context.getExecutionTimeRecorder().recordExecutionTime("Draw all labels", () -> sharedState.drawAllLabels(this.ratioHeightForLabel, this.alignerLabel));
                this.writeMontage(context.getOutputter().writerPermissive(), OUTPUT_LABELLED, sharedState);
            }
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException("A problem occurred drawing labels on the montaged image", (Throwable)e);
        }
    }

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(StackSequenceInput.class);
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_LABELLED});
    }

    private StackArranger createArranger(List<SizeMapping> imageSizes, Optional<ImageSizeSuggestion> suggestedSize) throws OperationFailedException {
        int numberRows = this.calculateNumberRows(imageSizes.size());
        if (this.varyImageSize) {
            return new VaryingImageSizeArranger(this.varyingSizeWidth, this.varyingSizeWidthRatio).create(numberRows, suggestedSize, this.varyImageLocation);
        }
        return new FixedImageSizeArranger(this.fixedSizeScaler, this.aligner).create(numberRows, suggestedSize, imageSizes);
    }

    private int calculateNumberRows(int numberImagesToArrange) {
        return (int)Math.ceil(Math.sqrt(numberImagesToArrange) * this.ratioRowsToColumns);
    }

    private boolean labelsEnabled(Outputter outputter) {
        return outputter.outputsEnabled().isOutputEnabled(OUTPUT_LABELLED);
    }

    private RGBStack readStackFromInput(InputBound<StackSequenceInput, MontageSharedState> input) throws InputReadFailedException {
        try {
            Stack stack = ((StackSequenceInput)input.getInput()).asStack(input.getLogger()).projectMax();
            return ConvertStackToRGB.convert((Stack)stack, (StackDisplayer)this.displayer, (boolean)false);
        }
        catch (CreateException | OperationFailedException e) {
            throw new InputReadFailedException("Cannot extract a stack representation from the input", e);
        }
    }

    private void writeMontage(WriterRouterErrors writer, String outputName, MontageSharedState sharedState) {
        writer.write(outputName, () -> new StackGenerator(true), () -> ((RGBStack)sharedState.getStack()).asStack());
    }

    @Generated
    public ImageMetadataReader getImageMetadataReader() {
        return this.imageMetadataReader;
    }

    @Generated
    public void setImageMetadataReader(ImageMetadataReader imageMetadataReader) {
        this.imageMetadataReader = imageMetadataReader;
    }

    @Generated
    public StackReader getStackReader() {
        return this.stackReader;
    }

    @Generated
    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Generated
    public boolean isVaryImageSize() {
        return this.varyImageSize;
    }

    @Generated
    public void setVaryImageSize(boolean varyImageSize) {
        this.varyImageSize = varyImageSize;
    }

    @Generated
    public boolean isVaryImageLocation() {
        return this.varyImageLocation;
    }

    @Generated
    public void setVaryImageLocation(boolean varyImageLocation) {
        this.varyImageLocation = varyImageLocation;
    }

    @Generated
    public BoxAligner getAligner() {
        return this.aligner;
    }

    @Generated
    public void setAligner(BoxAligner aligner) {
        this.aligner = aligner;
    }

    @Generated
    public double getRatioHeightForLabel() {
        return this.ratioHeightForLabel;
    }

    @Generated
    public void setRatioHeightForLabel(double ratioHeightForLabel) {
        this.ratioHeightForLabel = ratioHeightForLabel;
    }

    @Generated
    public BoxAligner getAlignerLabel() {
        return this.alignerLabel;
    }

    @Generated
    public void setAlignerLabel(BoxAligner alignerLabel) {
        this.alignerLabel = alignerLabel;
    }

    @Generated
    public ScaleCalculator getFixedSizeScaler() {
        return this.fixedSizeScaler;
    }

    @Generated
    public void setFixedSizeScaler(ScaleCalculator fixedSizeScaler) {
        this.fixedSizeScaler = fixedSizeScaler;
    }

    @Generated
    public int getVaryingSizeWidth() {
        return this.varyingSizeWidth;
    }

    @Generated
    public void setVaryingSizeWidth(int varyingSizeWidth) {
        this.varyingSizeWidth = varyingSizeWidth;
    }

    @Generated
    public double getVaryingSizeWidthRatio() {
        return this.varyingSizeWidthRatio;
    }

    @Generated
    public void setVaryingSizeWidthRatio(double varyingSizeWidthRatio) {
        this.varyingSizeWidthRatio = varyingSizeWidthRatio;
    }

    @Generated
    public double getRatioRowsToColumns() {
        return this.ratioRowsToColumns;
    }

    @Generated
    public void setRatioRowsToColumns(double ratioRowsToColumns) {
        this.ratioRowsToColumns = ratioRowsToColumns;
    }

    @Generated
    public StackDisplayer getDisplayer() {
        return this.displayer;
    }

    @Generated
    public void setDisplayer(StackDisplayer displayer) {
        this.displayer = displayer;
    }
}

