/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.feature;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.NonEmpty;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.io.csv.metadata.LabelHeaders;
import org.anchoranalysis.feature.io.results.FeatureOutputNames;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.feature.store.NamedFeatureStoreFactory;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.bean.grouper.Grouper;
import org.anchoranalysis.io.input.bean.path.DerivePath;
import org.anchoranalysis.io.input.grouper.InputGrouper;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.image.task.bean.feature.AggregateFeaturesCreator;
import org.anchoranalysis.plugin.image.task.bean.feature.ExportFeaturesStyle;
import org.anchoranalysis.plugin.image.task.bean.feature.source.FeatureSource;
import org.anchoranalysis.plugin.image.task.feature.FeatureCalculationContext;
import org.anchoranalysis.plugin.image.task.feature.FeatureExporter;
import org.anchoranalysis.plugin.image.task.feature.FeatureExporterContext;

public class ExportFeatures<T extends InputFromManager, S, U extends FeatureInput>
extends Task<T, FeatureExporter<S>> {
    private static final NamedFeatureStoreFactory STORE_FACTORY_AGGREGATE = NamedFeatureStoreFactory.bothNameAndParameters();
    public static final FeatureOutputNames OUTPUT_NAMES = new FeatureOutputNames();
    @BeanField
    private FeatureSource<T, S, U> source;
    @BeanField
    @DefaultInstance
    private Grouper group;
    @BeanField
    @OptionalBean
    private DerivePath id;
    @BeanField
    @NonEmpty
    private List<NamedBean<FeatureListProvider<U>>> features = new ArrayList<NamedBean<FeatureListProvider<U>>>();
    @BeanField
    @OptionalBean
    private List<NamedBean<FeatureListProvider<FeatureInputResults>>> featuresAggregate;
    @BeanField
    ExportFeaturesStyle style = new ExportFeaturesStyle();

    public FeatureExporter<S> beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<T> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            FeatureExporterContext context = this.style.deriveContext((InputOutputContext)parameters.getContext());
            Optional grouper = this.group.createInputGrouper(parameters.getExecutionArguments().task().getGroupIndexRange());
            LabelHeaders headers = this.source.headers(grouper.isPresent());
            FeatureExporter<S> exporter = this.source.createExporter(headers, this.features, OUTPUT_NAMES, grouper, context);
            if (this.featuresAggregate == null) {
                this.featuresAggregate = AggregateFeaturesCreator.createDefaultFeatures(exporter.getFeatureNames());
            }
            return exporter;
        }
        catch (CreateException e) {
            throw new ExperimentExecutionException((Throwable)e);
        }
    }

    public void doJobOnInput(InputBound<T, FeatureExporter<S>> input) throws JobExecutionException {
        try {
            Optional<String> groupName = this.extractGroupNameFromGenerator(((InputFromManager)input.getInput()).pathForBindingRequired(), ((FeatureExporter)input.getSharedState()).getGrouper());
            FeatureCalculationContext calculationContext = ((FeatureExporter)input.getSharedState()).createCalculationContext(groupName, input.getContextExperiment().getExecutionTimeRecorder(), (InputOutputContext)input.getContextJob());
            this.source.calculateAndOutput((InputFromManager)input.getInput(), calculationContext);
        }
        catch (OperationFailedException | InputReadFailedException | DerivePathException e) {
            throw new JobExecutionException(e);
        }
    }

    public void afterAllJobsAreExecuted(FeatureExporter<S> sharedState, InputOutputContext context) throws ExperimentExecutionException {
        try {
            sharedState.closeAndWriteOutputs(this.featuresAggregateAsStore(), this.source.includeGroupInExperiment(sharedState.getGrouper().isPresent()), contextForWriter -> this.style.deriveContext((InputOutputContext)contextForWriter)::csvWriter, context);
        }
        catch (ProvisionFailedException | OutputWriteFailedException e) {
            throw new ExperimentExecutionException(e);
        }
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_NAMES.getCsvFeaturesNonAggregated()});
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public InputTypesExpected inputTypesExpected() {
        return this.source.inputTypesExpected();
    }

    private Optional<NamedFeatureStore<FeatureInputResults>> featuresAggregateAsStore() throws ProvisionFailedException {
        return OptionalUtilities.map(Optional.ofNullable(this.featuresAggregate), arg_0 -> ((NamedFeatureStoreFactory)STORE_FACTORY_AGGREGATE).createNamedFeatureList(arg_0));
    }

    private Optional<String> extractGroupNameFromGenerator(Path inputPath, Optional<InputGrouper> grouper) throws DerivePathException {
        return OptionalUtilities.map(grouper, grouperInternal -> grouperInternal.deriveGroupKeyOptional(inputPath));
    }

    @Generated
    public FeatureSource<T, S, U> getSource() {
        return this.source;
    }

    @Generated
    public void setSource(FeatureSource<T, S, U> source) {
        this.source = source;
    }

    @Generated
    public Grouper getGroup() {
        return this.group;
    }

    @Generated
    public void setGroup(Grouper group) {
        this.group = group;
    }

    @Generated
    public DerivePath getId() {
        return this.id;
    }

    @Generated
    public void setId(DerivePath id) {
        this.id = id;
    }

    @Generated
    public List<NamedBean<FeatureListProvider<U>>> getFeatures() {
        return this.features;
    }

    @Generated
    public void setFeatures(List<NamedBean<FeatureListProvider<U>>> features) {
        this.features = features;
    }

    @Generated
    public List<NamedBean<FeatureListProvider<FeatureInputResults>>> getFeaturesAggregate() {
        return this.featuresAggregate;
    }

    @Generated
    public void setFeaturesAggregate(List<NamedBean<FeatureListProvider<FeatureInputResults>>> featuresAggregate) {
        this.featuresAggregate = featuresAggregate;
    }

    @Generated
    public ExportFeaturesStyle getStyle() {
        return this.style;
    }

    @Generated
    public void setStyle(ExportFeaturesStyle style) {
        this.style = style;
    }
}

