/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.format;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.NoSharedState;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.image.bean.channel.ConvertChannelTo;
import org.anchoranalysis.image.core.channel.convert.ConversionPolicy;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.channel.input.ChannelGetter;
import org.anchoranalysis.image.io.channel.input.NamedChannelsInput;
import org.anchoranalysis.image.io.channel.map.NamedChannelsMap;
import org.anchoranalysis.image.io.stack.output.OutputSequenceStackFactory;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.generator.sequence.OutputSequenceIndexed;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.image.task.bean.RasterTask;
import org.anchoranalysis.plugin.image.task.bean.format.CalculateOutputName;
import org.anchoranalysis.plugin.image.task.bean.format.ConvertingChannels;
import org.anchoranalysis.plugin.image.task.bean.format.convertstyle.ChannelConvertStyle;
import org.anchoranalysis.plugin.image.task.bean.format.convertstyle.RGBIfNamesMatch;
import org.anchoranalysis.plugin.image.task.stack.ChannelGetterForTimepoint;

public class ConvertImageFormat
extends RasterTask<NoSharedState, OutputSequenceIndexed<Stack, String>> {
    private static final String OUTPUT_COPY = "converted";
    @BeanField
    private ChannelConvertStyle channelConversionStyle = new RGBIfNamesMatch();
    @BeanField
    private boolean suppressSeries = false;
    @BeanField
    @OptionalBean
    private ConvertChannelTo<?> channelConverter = null;

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_COPY});
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public NoSharedState beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<NamedChannelsInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        return NoSharedState.INSTANCE;
    }

    @Override
    protected OutputSequenceIndexed<Stack, String> createSharedStateJob(InputOutputContext context) throws JobExecutionException {
        try {
            return OutputSequenceStackFactory.NO_RESTRICTIONS.withoutOrderCurrentDirectory(OUTPUT_COPY, context.getOutputter().getChecked());
        }
        catch (OutputWriteFailedException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    @Override
    public void startSeries(NoSharedState sharedStateTask, OutputSequenceIndexed<Stack, String> sharedStateJob, InputOutputContext context) throws JobExecutionException {
    }

    @Override
    public void doStack(InputBound<NamedChannelsInput, NoSharedState> input, OutputSequenceIndexed<Stack, String> sharedStateJob, int seriesIndex, int numberSeries, InputOutputContext context) throws JobExecutionException {
        try {
            NamedChannelsMap channels;
            NamedChannelsMap channelGetter = channels = this.createNamedChannels((NamedChannelsInput)input.getInput(), seriesIndex, context.getLogger());
            if (this.channelConverter != null) {
                channelGetter = this.maybeAddConverter((ChannelGetter)channels);
            }
            int numberTimepoints = (Integer)context.getExecutionTimeRecorder().recordExecutionTime("Determining number of timepoints", () -> channels.sizeT(context.getLogger()));
            this.convertEachTimepoint(seriesIndex, channels.channelNames(), numberSeries, numberTimepoints, (ChannelGetter)channelGetter, sharedStateJob, context);
        }
        catch (CreateException | ImageIOException e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public void endSeries(NoSharedState sharedStateTask, OutputSequenceIndexed<Stack, String> sharedStateJob, InputOutputContext context) throws JobExecutionException {
    }

    public void afterAllJobsAreExecuted(NoSharedState sharedState, InputOutputContext context) throws ExperimentExecutionException {
    }

    private void convertEachTimepoint(int seriesIndex, Set<String> channelNames, int numberSeries, int sizeT, ChannelGetter channelGetter, OutputSequenceIndexed<Stack, String> outputSequence, InputOutputContext context) throws JobExecutionException {
        for (int t = 0; t < sizeT; ++t) {
            CalculateOutputName namer = new CalculateOutputName(seriesIndex, t, numberSeries, sizeT, this.suppressSeries);
            context.getLogger().messageLogger().logFormatted("Starting time-point: %d", new Object[]{t});
            try {
                NamedStacks stacks = this.channelConversionStyle.convert(channelNames, new ChannelGetterForTimepoint(channelGetter, t), context.getLogger());
                stacks.forEach((existingName, stack) -> this.addStackToOutput(outputSequence, ConvertImageFormat.maybeSuppressExistingName(stacks, existingName), (StoreSupplier<Stack>)stack, namer));
            }
            catch (OperationFailedException e) {
                throw new JobExecutionException((Throwable)e);
            }
            context.getLogger().messageLogger().logFormatted("Ending time-point: %d", new Object[]{t});
        }
    }

    private NamedChannelsMap createNamedChannels(NamedChannelsInput input, int seriesIndex, Logger logger) throws ImageIOException {
        return input.createChannelsForSeries(seriesIndex, logger);
    }

    private void addStackToOutput(OutputSequenceIndexed<Stack, String> outputSequence, Optional<String> existingName, StoreSupplier<Stack> stackSupplier, CalculateOutputName namer) throws OperationFailedException {
        try {
            Optional<String> outputName = namer.calculateOutputName(existingName);
            outputSequence.add((Object)((Stack)stackSupplier.get()), outputName);
        }
        catch (OutputWriteFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private ChannelGetter maybeAddConverter(ChannelGetter channelGetter) throws CreateException {
        if (this.channelConverter != null) {
            return new ConvertingChannels(channelGetter, this.channelConverter.createConverter(), ConversionPolicy.CHANGE_EXISTING_CHANNEL);
        }
        return channelGetter;
    }

    private static Optional<String> maybeSuppressExistingName(NamedStacks stacks, String existingName) {
        return OptionalFactory.create((stacks.size() > 1 ? 1 : 0) != 0, () -> existingName);
    }

    @Generated
    public ChannelConvertStyle getChannelConversionStyle() {
        return this.channelConversionStyle;
    }

    @Generated
    public void setChannelConversionStyle(ChannelConvertStyle channelConversionStyle) {
        this.channelConversionStyle = channelConversionStyle;
    }

    @Generated
    public boolean isSuppressSeries() {
        return this.suppressSeries;
    }

    @Generated
    public void setSuppressSeries(boolean suppressSeries) {
        this.suppressSeries = suppressSeries;
    }

    @Generated
    public ConvertChannelTo<?> getChannelConverter() {
        return this.channelConverter;
    }

    @Generated
    public void setChannelConverter(ConvertChannelTo<?> channelConverter) {
        this.channelConverter = channelConverter;
    }
}

