/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.grouped;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.checked.CheckedBiConsumer;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputOutputContextStateful;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.nonbean.ConsistentChannelChecker;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.bean.grouper.Grouper;
import org.anchoranalysis.io.input.grouper.InputGrouper;
import org.anchoranalysis.io.input.path.DerivePathException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.plugin.image.task.bean.grouped.selectchannels.All;
import org.anchoranalysis.plugin.image.task.bean.grouped.selectchannels.FromStacks;
import org.anchoranalysis.plugin.image.task.channel.aggregator.NamedChannels;
import org.anchoranalysis.plugin.image.task.grouped.ChannelSource;
import org.anchoranalysis.plugin.image.task.grouped.GroupMapByName;
import org.anchoranalysis.plugin.image.task.grouped.GroupedSharedState;
import org.apache.commons.math3.util.Pair;

public abstract class GroupedStackBase<S, T>
extends Task<ProvidesStackInput, GroupedSharedState<S, T>> {
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;
    @BeanField
    @OptionalBean
    @DefaultInstance
    private Grouper group;
    @BeanField
    private FromStacks selectChannels = new All();
    @BeanField
    @OptionalBean
    private SizeXY resizeTo;

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(ProvidesStackInput.class);
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public GroupedSharedState<S, T> beforeAnyJobIsExecuted(Outputter outputter, ConcurrencyPlan concurrencyPlan, List<ProvidesStackInput> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        OperationContext operationContext = parameters.getContext().operationContext();
        boolean outputEnabled = parameters.getContext().getOutputter().outputsEnabled().isOutputEnabled(this.outputNameForGroups());
        Optional outputContext = OptionalFactory.createChecked((boolean)outputEnabled, () -> parameters.getContext().maybeSubdirectory(this.subdirectoryForGroupOutputs(), false));
        Optional grouper = this.group.createInputGrouper(parameters.getExecutionArguments().task().getGroupIndexRange());
        Optional groupIdentifiers = OptionalUtilities.map((Optional)grouper, grouperInternal -> this.allGroupIdentifiers(inputs, (InputGrouper)grouperInternal));
        return new GroupedSharedState(grouper, checker -> this.createGroupMap((ConsistentChannelChecker)checker, groupIdentifiers.map(Collection::stream), outputContext, operationContext));
    }

    public void doJobOnInput(InputBound<ProvidesStackInput, GroupedSharedState<S, T>> input) throws JobExecutionException {
        ProvidesStackInput inputStack = (ProvidesStackInput)input.getInput();
        InputOutputContextStateful context = input.getContextJob();
        Optional<String> groupName = this.deriveGroup(inputStack.identifierAsPath(), ((GroupedSharedState)input.getSharedState()).getGrouper());
        this.processStacks(GroupedStackBase.extractInputStacks(inputStack, context.getLogger()), groupName, (GroupedSharedState)input.getSharedState(), (InputOutputContext)context);
    }

    public void afterAllJobsAreExecuted(GroupedSharedState<S, T> sharedState, InputOutputContext context) throws ExperimentExecutionException {
        try {
            sharedState.getGroupMap().outputAnyRemainingGroups();
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException("An error occurred outputting an aggregate", (Throwable)e);
        }
    }

    protected abstract String outputNameForGroups();

    protected abstract Optional<String> subdirectoryForGroupOutputs();

    protected abstract GroupMapByName<S, T> createGroupMap(ConsistentChannelChecker var1, Optional<Stream<String>> var2, Optional<InputOutputContext> var3, OperationContext var4);

    protected abstract CheckedFunction<Channel, S, CreateException> createChannelDeriver(ChannelSource var1) throws OperationFailedException;

    protected abstract void processIndividual(String var1, S var2, boolean var3, CheckedBiConsumer<String, S, OperationFailedException> var4, InputOutputContext var5) throws OperationFailedException;

    private void processStacks(NamedStacks store, Optional<String> groupName, GroupedSharedState<S, T> sharedState, InputOutputContext context) throws JobExecutionException {
        LinkedList toAdd = new LinkedList();
        try {
            ChannelSource source = new ChannelSource(store, sharedState.getChannelChecker(), Optional.ofNullable(this.resizeTo), this.getInterpolator().voxelsResizer());
            CheckedFunction<Channel, S, CreateException> deriveIndividualFromChannel = this.createChannelDeriver(source);
            NamedChannels channels = this.getSelectChannels().selectChannels(source, true);
            sharedState.getChannelNamesChecker().checkChannelNames(channels.names(), channels.isRgb());
            for (Map.Entry<String, Channel> entry : channels) {
                Object individual = deriveIndividualFromChannel.apply((Object)entry.getValue());
                this.processIndividual(entry.getKey(), individual, groupName.isPresent(), (name, histogram) -> toAdd.add(new Pair(name, individual)), context);
            }
        }
        catch (CreateException | OperationFailedException e) {
            this.addToGroupMap(sharedState, groupName, toAdd);
            throw new JobExecutionException(e);
        }
        this.addToGroupMap(sharedState, groupName, toAdd);
    }

    private void addToGroupMap(GroupedSharedState<S, T> sharedState, Optional<String> groupName, List<Pair<String, S>> toAdd) throws JobExecutionException {
        try {
            sharedState.getGroupMap().add(groupName, toAdd);
        }
        catch (OperationFailedException e) {
            throw new JobExecutionException("An error occurred updating the group map", (Throwable)e);
        }
    }

    private Optional<String> deriveGroup(Path identifier, Optional<InputGrouper> grouper) throws JobExecutionException {
        try {
            if (!grouper.isPresent()) {
                return Optional.empty();
            }
            return Optional.of(grouper.get().deriveGroupKeyOptional(identifier));
        }
        catch (DerivePathException e) {
            throw new JobExecutionException(String.format("Cannot establish a group-identifier for: %s", identifier), (Throwable)e);
        }
    }

    private List<String> allGroupIdentifiers(List<ProvidesStackInput> inputs, InputGrouper grouper) throws ExperimentExecutionException {
        try {
            return FunctionalList.mapToList(inputs, DerivePathException.class, input -> grouper.deriveGroupKeyOptional(input.identifierAsPath()));
        }
        catch (DerivePathException e) {
            throw new ExperimentExecutionException("Unable to derive a group identifier for an input", (Throwable)e);
        }
    }

    private static NamedStacks extractInputStacks(ProvidesStackInput input, Logger logger) throws JobExecutionException {
        try {
            NamedStacks stacks = new NamedStacks();
            input.addToStoreInferNames((NamedProviderStore)stacks, logger);
            return stacks;
        }
        catch (OperationFailedException e1) {
            throw new JobExecutionException("An error occurred creating inputs to the task", (Throwable)e1);
        }
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Generated
    public Grouper getGroup() {
        return this.group;
    }

    @Generated
    public void setGroup(Grouper group) {
        this.group = group;
    }

    @Generated
    public FromStacks getSelectChannels() {
        return this.selectChannels;
    }

    @Generated
    public void setSelectChannels(FromStacks selectChannels) {
        this.selectChannels = selectChannels;
    }

    @Generated
    public SizeXY getResizeTo() {
        return this.resizeTo;
    }

    @Generated
    public void setResizeTo(SizeXY resizeTo) {
        this.resizeTo = resizeTo;
    }
}

