/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.grouped.selectchannels;

import java.util.Set;
import java.util.stream.Stream;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.plugin.image.task.bean.grouped.selectchannels.FromStacks;
import org.anchoranalysis.plugin.image.task.channel.aggregator.NamedChannels;
import org.anchoranalysis.plugin.image.task.grouped.ChannelSource;

public class All
extends FromStacks {
    @Override
    public NamedChannels selectChannels(ChannelSource source, boolean checkType) throws OperationFailedException {
        Set keys = source.getStackStore().keys();
        Stream stream = CheckedStream.map(keys.stream(), OperationFailedException.class, key -> this.extractAllChannels(source, (String)key, checkType));
        return new NamedChannels(stream);
    }

    private NamedChannels extractAllChannels(ChannelSource source, String stackName, boolean checkType) throws OperationFailedException {
        try {
            Stack stack = (Stack)source.getStackStore().getException(stackName);
            NamedChannels out = new NamedChannels(stack.isRGB());
            for (int i = 0; i < stack.getNumberChannels(); ++i) {
                String outputName = stackName + All.createSuffix(i, stack.getNumberChannels() > 1);
                out.add(outputName, source.extractChannel(stack, checkType, i));
            }
            return out;
        }
        catch (NamedProviderGetException e) {
            throw new OperationFailedException(e.summarize());
        }
    }

    private static String createSuffix(int index, boolean hasMultipleChannels) {
        if (hasMultipleChannels) {
            return String.format("%02d", index);
        }
        return "";
    }
}

