/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.scale;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.NamedStacksOutputter;
import org.anchoranalysis.image.io.stack.output.generator.StackGenerator;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.writer.ElementSupplier;
import org.anchoranalysis.io.output.writer.ElementWriterSupplier;
import org.anchoranalysis.io.output.writer.Writer;
import org.anchoranalysis.plugin.image.task.bean.scale.DualEnabled;
import org.anchoranalysis.plugin.image.task.bean.scale.DualNamedStacks;

class OutputterHelper {
    public static boolean isFirstLevelOutputEnabled(String outputName, InputOutputContext context) {
        return context.getOutputter().outputsEnabled().isOutputEnabled(outputName);
    }

    public static boolean isSecondLevelOutputEnabled(String outputNameFirstLevel, String keySecondLevel, InputOutputContext context) {
        return context.getOutputter().outputsEnabled().second(outputNameFirstLevel).isOutputEnabled(keySecondLevel);
    }

    public static void outputStacks(DualNamedStacks dualStacks, DualEnabled dualEnabled, String outputNameNonFlattened, String outputNamedFlattened, OutputterChecked outputter) throws JobExecutionException {
        OutputterHelper.outputStacks((NamedProvider<Stack>)dualStacks.nonFlattened(), outputNameNonFlattened, outputter, !dualEnabled.isFlattened(), false);
        OutputterHelper.outputStacks((NamedProvider<Stack>)dualStacks.flattened(), outputNamedFlattened, outputter, !dualEnabled.isNonFlattened(), true);
    }

    private static void outputStacks(NamedProvider<Stack> stacks, String outputName, OutputterChecked outputter, boolean suppressOutputNameIfPossible, boolean always2D) throws JobExecutionException {
        try {
            int numberStacks = stacks.keys().size();
            if (numberStacks > 1) {
                NamedStacksOutputter.output(stacks, (String)outputName, (boolean)false, (OutputterChecked)outputter);
            } else if (numberStacks == 1) {
                OutputterHelper.outputSingleStack(stacks, outputName, outputter.getWriters().permissive(), suppressOutputNameIfPossible, always2D);
            }
        }
        catch (OutputWriteFailedException e) {
            throw new JobExecutionException("Failed to write a particular stack in: " + outputName, (Throwable)e);
        }
    }

    private static void outputSingleStack(NamedProvider<Stack> stacks, String outputName, Writer writer, boolean suppressOutputNameIfPossible, boolean always2D) throws OutputWriteFailedException {
        ElementWriterSupplier writerSupplier = () -> new StackGenerator(always2D);
        ElementSupplier elementSupplier = () -> OutputterHelper.extractArbitraryStack(stacks);
        if (suppressOutputNameIfPossible) {
            writer.writeWithoutName(outputName, writerSupplier, elementSupplier);
        } else {
            writer.write(outputName, writerSupplier, elementSupplier);
        }
    }

    private static Stack extractArbitraryStack(NamedProvider<Stack> stacks) {
        try {
            return (Stack)stacks.getArbitraryElement();
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    @Generated
    private OutputterHelper() {
    }
}

