/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.scale;

import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.io.stack.input.StackSequenceInput;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.bean.scale.DualEnabled;
import org.anchoranalysis.plugin.image.task.bean.scale.DualNamedStacks;
import org.anchoranalysis.plugin.image.task.bean.scale.OutputterHelper;
import org.anchoranalysis.plugin.image.task.stack.InitializationFactory;

public abstract class ScaleImage<S>
extends Task<StackSequenceInput, S> {
    static final String OUTPUT_SCALED = "scaled";
    private static final String OUTPUT_SCALED_FLATTENED = "scaledFlattened";
    @BeanField
    protected ScaleCalculator scaleCalculator;
    @BeanField
    protected boolean binary = false;
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(StackSequenceInput.class);
    }

    public void doJobOnInput(InputBound<StackSequenceInput, S> input) throws JobExecutionException {
        try {
            NamedStacks stacks = ((StackSequenceInput)input.getInput()).asSet(input.getLogger());
            ImageInitialization initialization = InitializationFactory.createWithoutStacks(input.createInitializationContext());
            initialization.addStacksFrom((NamedProvider)stacks);
            this.populateAndOutput(input.getSharedState(), initialization, (InputOutputContext)input.getContextJob());
        }
        catch (OperationFailedException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    public void afterAllJobsAreExecuted(S sharedState, InputOutputContext context) throws ExperimentExecutionException {
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public OutputEnabledMutable defaultOutputs() {
        return super.defaultOutputs().addEnabledOutputFirst(new String[]{OUTPUT_SCALED});
    }

    private void populateAndOutput(S sharedState, ImageInitialization initialization, InputOutputContext context) throws JobExecutionException {
        DualNamedStacks stacks = new DualNamedStacks();
        DualEnabled dualEnabled = new DualEnabled(OutputterHelper.isFirstLevelOutputEnabled(OUTPUT_SCALED, context), OutputterHelper.isFirstLevelOutputEnabled(OUTPUT_SCALED_FLATTENED, context));
        if (dualEnabled.isEitherEnabled()) {
            this.populateStacksFromSharedObjects(sharedState, initialization, stacks, dualEnabled, context);
            OutputterHelper.outputStacks(stacks, dualEnabled, OUTPUT_SCALED, OUTPUT_SCALED_FLATTENED, context.getOutputter().getChecked());
        }
    }

    private void populateStacksFromSharedObjects(S sharedState, ImageInitialization initialization, DualNamedStacks stacksToAddTo, DualEnabled dualEnabled, InputOutputContext context) throws JobExecutionException {
        Set inputKeys = initialization.stacks().keys();
        for (String key : inputKeys) {
            DualEnabled enabledForKey = dualEnabled.and(() -> OutputterHelper.isSecondLevelOutputEnabled(OUTPUT_SCALED, key, context), () -> OutputterHelper.isSecondLevelOutputEnabled(OUTPUT_SCALED_FLATTENED, key, context));
            if (!enabledForKey.isEitherEnabled()) continue;
            try {
                Stack stackIn = (Stack)initialization.stacks().getException(key);
                Stack stackOut = this.scaleStack(stackIn, initialization.suggestedSize(), this.interpolator.voxelsResizer(), sharedState);
                stacksToAddTo.addStack(key, stackOut, enabledForKey);
            }
            catch (OperationFailedException e) {
                throw new JobExecutionException((Throwable)e);
            }
            catch (NamedProviderGetException e) {
                throw new JobExecutionException(e.summarize());
            }
        }
    }

    protected abstract Stack scaleStack(Stack var1, Optional<ImageSizeSuggestion> var2, VoxelsResizer var3, S var4) throws OperationFailedException;

    @Generated
    public ScaleCalculator getScaleCalculator() {
        return this.scaleCalculator;
    }

    @Generated
    public void setScaleCalculator(ScaleCalculator scaleCalculator) {
        this.scaleCalculator = scaleCalculator;
    }

    @Generated
    public boolean isBinary() {
        return this.binary;
    }

    @Generated
    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

