/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.slice;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class ExtractProjectedStack {
    private Optional<Extent> extent;

    public Stack extractAndProjectStack(Channel red, Channel green, Channel blue, int z) throws IncorrectImageSizeException {
        Stack stack = new Stack();
        this.extractAndProjectChannel(red, z, stack);
        this.extractAndProjectChannel(green, z, stack);
        this.extractAndProjectChannel(blue, z, stack);
        return stack;
    }

    private void extractAndProjectChannel(Channel channel, int z, Stack stack) throws IncorrectImageSizeException {
        Channel channelProjected = this.createProjectedChannel(channel.extractSlice(z).duplicate());
        stack.addChannel(channelProjected);
    }

    private Channel createProjectedChannel(Channel channelIn) {
        if (!this.extent.isPresent() || channelIn.extent().equals((Object)this.extent.get())) {
            return channelIn;
        }
        Point3i corner = ExtractProjectedStack.createTarget(channelIn.dimensions(), this.extent.get());
        BoundingBox boxToProject = ExtractProjectedStack.boxToProject(corner, channelIn.extent(), this.extent.get());
        BoundingBox boxSource = ExtractProjectedStack.boxSource(boxToProject, channelIn.dimensions());
        return this.copyPixels(boxSource, boxToProject, channelIn, this.extent.get());
    }

    private static Point3i createTarget(Dimensions dimensions, Extent extent) {
        return new Point3i((extent.x() - dimensions.x()) / 2, (extent.y() - dimensions.y()) / 2, 0);
    }

    private static BoundingBox boxToProject(Point3i corner, Extent extentChannel, Extent extentTarget) {
        return (BoundingBox)BoundingBox.createReuse((ReadableTuple3i)corner, (Extent)extentChannel).intersection().with(new BoundingBox(extentTarget)).orElseThrow(AnchorImpossibleSituationException::new);
    }

    private static BoundingBox boxSource(BoundingBox boxToProject, Dimensions dimensions) {
        Point3i sourceCorner = ExtractProjectedStack.createSourceCorner(boxToProject, dimensions);
        return BoundingBox.createReuse((ReadableTuple3i)sourceCorner, (Extent)boxToProject.extent());
    }

    private static Point3i createSourceCorner(BoundingBox boxToProject, Dimensions dimensions) {
        Point3i sourceCorner = new Point3i(0, 0, 0);
        if (boxToProject.extent().x() < dimensions.x()) {
            sourceCorner.setX((dimensions.x() - boxToProject.extent().x()) / 2);
        }
        if (boxToProject.extent().y() < dimensions.y()) {
            sourceCorner.setY((dimensions.y() - boxToProject.extent().y()) / 2);
        }
        return sourceCorner;
    }

    private Channel copyPixels(BoundingBox boxSource, BoundingBox boxToProject, Channel channelDestination, Extent extentOut) {
        Channel channelOut = ChannelFactory.instance().create(new Dimensions(extentOut, channelDestination.resolution()), (VoxelDataType)UnsignedByteVoxelType.INSTANCE);
        channelDestination.voxels().asByte().extract().boxCopyTo(boxSource, channelOut.voxels().asByte(), boxToProject);
        return channelOut;
    }

    @Generated
    public ExtractProjectedStack(Optional<Extent> extent) {
        this.extent = extent;
    }
}

