/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.io.generator.serialized.DictionaryGenerator;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.writer.ElementSupplier;
import org.anchoranalysis.plugin.image.task.bean.feature.source.FromHistogram;

class DictionaryExporter {
    public static void export(FeatureNameList featureNames, ResultsVector results, String outputName, InputOutputContext context) {
        DictionaryExporter.writeDictionary((ElementSupplier<Dictionary>)((ElementSupplier)() -> DictionaryExporter.convert(featureNames, results, context.getLogger())), context.getOutputter(), outputName);
    }

    private static void writeDictionary(ElementSupplier<Dictionary> dictionary, Outputter outputter, String outputName) {
        outputter.writerSelective().write(outputName, DictionaryGenerator::new, dictionary);
    }

    private static Dictionary convert(FeatureNameList featureNames, ResultsVector rv, Logger logger) {
        assert (featureNames.size() == rv.size());
        Dictionary dictionary = new Dictionary();
        for (int i = 0; i < featureNames.size(); ++i) {
            String key = featureNames.get(i);
            Optional val = rv.getResult(i);
            if (val.isPresent()) {
                dictionary.put(key, ((Double)val.get()).doubleValue());
                continue;
            }
            logger.errorReporter().recordError(FromHistogram.class, (Throwable)rv.getError(i));
            dictionary.put(key, Double.NaN);
        }
        return dictionary;
    }

    @Generated
    private DictionaryExporter() {
    }
}

