/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.grouped;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.image.bean.nonbean.ConsistentChannelChecker;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.core.stack.named.NamedStacks;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;

public class ChannelSource {
    private final NamedStacks stackStore;
    private final ConsistentChannelChecker channelChecker;
    private final Optional<SizeXY> resizeTo;
    private final VoxelsResizer resizer;

    public Channel extractChannel(String stackName, boolean checkType) throws OperationFailedException {
        try {
            Stack stack = (Stack)this.stackStore.getException(stackName);
            if (stack.getNumberChannels() > 1) {
                throw new OperationFailedException("Each stack may only have a single channel");
            }
            return this.extractChannel(stack, checkType, 0);
        }
        catch (NamedProviderGetException e) {
            throw new OperationFailedException(String.format("Cannot extract a single channel from stack %s", stackName), e.summarize());
        }
    }

    public Channel extractChannel(String stackName, boolean checkType, int index) throws OperationFailedException {
        try {
            Stack stack = (Stack)this.stackStore.getException(stackName);
            return this.extractChannel(stack, checkType, index);
        }
        catch (NamedProviderGetException e) {
            throw new OperationFailedException(String.format("Cannot extract channel %d from stack %s", index, stackName), e.summarize());
        }
    }

    public Channel extractChannel(Stack stack, boolean checkType, int index) throws OperationFailedException {
        Channel channel = stack.getChannel(index);
        if (checkType) {
            this.channelChecker.checkChannelType(channel);
        }
        return this.maybeResize(channel);
    }

    private Channel maybeResize(Channel channel) {
        if (this.resizeTo.isPresent()) {
            return channel.resizeXY(this.resizeTo.get().getWidth(), this.resizeTo.get().getHeight(), this.resizer);
        }
        return channel;
    }

    @Generated
    public ChannelSource(NamedStacks stackStore, ConsistentChannelChecker channelChecker, Optional<SizeXY> resizeTo, VoxelsResizer resizer) {
        this.stackStore = stackStore;
        this.channelChecker = channelChecker;
        this.resizeTo = resizeTo;
        this.resizer = resizer;
    }

    @Generated
    public NamedStacks getStackStore() {
        return this.stackStore;
    }
}

