/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.grouped;

import com.google.common.base.Preconditions;
import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;

public class ConsistentChannelNamesChecker {
    private Set<String> channelNames;
    private boolean rgb;

    public void checkChannelNames(Set<String> channelNames, boolean rgb) throws OperationFailedException {
        Preconditions.checkArgument((!channelNames.isEmpty() ? 1 : 0) != 0);
        if (this.channelNames == null) {
            this.channelNames = channelNames;
            this.rgb = rgb;
        } else {
            if (!this.channelNames.equals(channelNames)) {
                throw new OperationFailedException(String.format("All images must have identical channel-names, but they are not consistent: %s versus %s", this.channelNames, channelNames));
            }
            if (this.rgb != rgb) {
                throw new OperationFailedException("All images must be either RGB, or not-RGB, but a mixture is not allowed");
            }
        }
    }

    @Generated
    public Set<String> getChannelNames() {
        return this.channelNames;
    }
}

