/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.stack;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.feature.io.csv.FeatureCSVWriter;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadata;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.Outputter;

public class SharedStateSelectedSlice {
    private final Optional<FeatureCSVWriter> csvWriter;

    public SharedStateSelectedSlice(Outputter baseOutputter) throws CreateException {
        try {
            this.csvWriter = FeatureCSVWriter.create((FeatureCSVMetadata)new FeatureCSVMetadata("selectedSlices", Arrays.asList("name", "sliceIndex", "featureOptima")), (Outputter)baseOutputter, (boolean)false);
        }
        catch (OutputWriteFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public synchronized void writeRow(String name, int selectedSliceIndex, double featureOptima) {
        List<TypedValue> row = Arrays.asList(new TypedValue(name), new TypedValue(selectedSliceIndex), new TypedValue(featureOptima, 7));
        this.csvWriter.ifPresent(writer -> writer.addRow(row));
    }

    public void close() {
        this.csvWriter.ifPresent(FeatureCSVWriter::close);
    }
}

