/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.combine;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.BoundingBoxEnclosed;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackArrangement;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.plugin.image.task.size.SizeMapping;
import org.anchoranalysis.plugin.image.task.slice.MontageSharedState;

class MontageSharedStateFactory {
    public static MontageSharedState create(List<SizeMapping> sizes, StackArranger arranger, VoxelsResizer resizer, OperationContext context) throws ExperimentExecutionException {
        try {
            StackArrangement arrangement = (StackArrangement)context.getExecutionTimeRecorder().recordExecutionTime("Arranging the stacks", () -> arranger.arrangeStacks(sizes.stream().map(SizeMapping::getExtent).iterator(), context));
            return new MontageSharedState(MontageSharedStateFactory.mapFromArrangement(sizes, arrangement), arrangement.extent(), resizer, context.getExecutionTimeRecorder());
        }
        catch (ArrangeStackException e) {
            throw new ExperimentExecutionException("Cannot determine a stack arrangement for", (Throwable)e);
        }
    }

    private static Map<Path, BoundingBoxEnclosed> mapFromArrangement(List<SizeMapping> sizes, StackArrangement arrangement) {
        HashMap<Path, BoundingBoxEnclosed> boxMapping = new HashMap<Path, BoundingBoxEnclosed>();
        for (int i = 0; i < sizes.size(); ++i) {
            boxMapping.put(sizes.get(i).getPath(), arrangement.get(i));
        }
        return boxMapping;
    }

    @Generated
    private MontageSharedStateFactory() {
    }
}

