/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.feature;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.Define;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.bean.results.Count;
import org.anchoranalysis.feature.bean.results.FeatureResultsStatistic;
import org.anchoranalysis.feature.bean.results.Maximum;
import org.anchoranalysis.feature.bean.results.Mean;
import org.anchoranalysis.feature.bean.results.Minimum;
import org.anchoranalysis.feature.bean.results.StandardDeviation;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.name.FeatureNameList;

class AggregateFeaturesCreator {
    public static List<NamedBean<FeatureListProvider<FeatureInputResults>>> createDefaultFeatures(FeatureNameList featuresToReference) {
        ArrayList<NamedBean<FeatureListProvider<FeatureInputResults>>> out = new ArrayList<NamedBean<FeatureListProvider<FeatureInputResults>>>();
        AggregateFeaturesCreator.addUnreferenced("count", (Feature<FeatureInputResults>)new Count(), out);
        for (String featureName : featuresToReference) {
            AggregateFeaturesCreator.addReferenced("mean", (FeatureResultsStatistic)new Mean(), featureName, out);
            AggregateFeaturesCreator.addReferenced("standardDeviation", (FeatureResultsStatistic)new StandardDeviation(), featureName, out);
            AggregateFeaturesCreator.addReferenced("min", (FeatureResultsStatistic)new Minimum(), featureName, out);
            AggregateFeaturesCreator.addReferenced("max", (FeatureResultsStatistic)new Maximum(), featureName, out);
        }
        return out;
    }

    private static void addReferenced(String name, FeatureResultsStatistic featureAggregate, String referenedFeature, List<NamedBean<FeatureListProvider<FeatureInputResults>>> toAddTo) {
        featureAggregate.setId(referenedFeature);
        AggregateFeaturesCreator.addUnreferenced(name + "." + referenedFeature, (Feature<FeatureInputResults>)featureAggregate, toAddTo);
    }

    private static void addUnreferenced(String name, Feature<FeatureInputResults> featureAggregate, List<NamedBean<FeatureListProvider<FeatureInputResults>>> toAddTo) {
        NamedBean bean = new NamedBean(name, (AnchorBean)new Define(featureAggregate));
        toAddTo.add((NamedBean<FeatureListProvider<FeatureInputResults>>)bean);
    }

    @Generated
    private AggregateFeaturesCreator() {
    }
}

