/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.feature.source;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.plugin.image.bean.thumbnail.stack.ScaleToSize;
import org.anchoranalysis.plugin.image.bean.thumbnail.stack.ThumbnailFromStack;
import org.anchoranalysis.plugin.image.task.bean.feature.source.SingleRowPerInput;
import org.anchoranalysis.plugin.image.task.feature.FeatureCalculationContext;
import org.anchoranalysis.plugin.image.task.feature.ResultsVectorWithThumbnail;
import org.anchoranalysis.plugin.image.task.feature.calculator.FeatureCalculatorFromProvider;

public class FromImage
extends SingleRowPerInput<ProvidesStackInput, FeatureInputStack> {
    @BeanField
    @OptionalBean
    private StackProvider stackEnergy;
    @BeanField
    private ThumbnailFromStack thumbnail = new ScaleToSize();

    public FromImage() {
        super("image");
    }

    @Override
    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(ProvidesStackInput.class);
    }

    @Override
    public boolean includeGroupInExperiment(boolean groupGeneratorDefined) {
        return groupGeneratorDefined;
    }

    @Override
    protected ResultsVectorWithThumbnail calculateResultsForInput(ProvidesStackInput input, FeatureCalculationContext<FeatureList<FeatureInputStack>> context) throws NamedFeatureCalculateException {
        FeatureCalculatorFromProvider<FeatureInputStack> calculator = this.createCalculator(input, context);
        this.thumbnail.start();
        return new ResultsVectorWithThumbnail((CheckedSupplier<ResultsVector, OperationFailedException>)((CheckedSupplier)() -> this.calculateResults(calculator, context)), (CheckedSupplier<Optional<DisplayStack>, OperationFailedException>)((CheckedSupplier)() -> this.extractThumbnail(calculator.getEnergyStack(), context.isThumbnailsEnabled())));
    }

    @Override
    protected Optional<String[]> additionalLabelsFor(ProvidesStackInput input) {
        return Optional.empty();
    }

    private ResultsVector calculateResults(FeatureCalculatorFromProvider<FeatureInputStack> factory, FeatureCalculationContext<FeatureList<FeatureInputStack>> context) throws OperationFailedException {
        try {
            return (ResultsVector)context.getExecutionTimeRecorder().recordExecutionTime("Calculating features", () -> {
                try {
                    FeatureCalculatorMulti calculator = factory.calculatorForAll((FeatureList)context.getFeatureSource());
                    return calculator.calculate((FeatureInput)new FeatureInputStack(), context.getLogger().errorReporter(), context.isSuppressErrors());
                }
                catch (InitializeException e) {
                    throw new NamedFeatureCalculateException((Exception)((Object)e));
                }
            });
        }
        catch (NamedFeatureCalculateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Optional<DisplayStack> extractThumbnail(EnergyStack energyStack, boolean thumbnails) throws OperationFailedException {
        if (thumbnails) {
            try {
                return Optional.of(this.thumbnail.thumbnailFor(energyStack.withoutParameters().asStack()));
            }
            catch (CreateException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return Optional.empty();
    }

    private FeatureCalculatorFromProvider<FeatureInputStack> createCalculator(ProvidesStackInput input, FeatureCalculationContext<FeatureList<FeatureInputStack>> context) throws NamedFeatureCalculateException {
        try {
            return (FeatureCalculatorFromProvider)context.getExecutionTimeRecorder().recordExecutionTime("Loading images", () -> new FeatureCalculatorFromProvider(input, Optional.ofNullable(this.stackEnergy), context.getContext()));
        }
        catch (OperationFailedException e) {
            throw new NamedFeatureCalculateException((Exception)((Object)e));
        }
    }

    @Generated
    public StackProvider getStackEnergy() {
        return this.stackEnergy;
    }

    @Generated
    public void setStackEnergy(StackProvider stackEnergy) {
        this.stackEnergy = stackEnergy;
    }

    @Generated
    public ThumbnailFromStack getThumbnail() {
        return this.thumbnail;
    }

    @Generated
    public void setThumbnail(ThumbnailFromStack thumbnail) {
        this.thumbnail = thumbnail;
    }
}

