/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.feature.source;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.image.core.stack.ImageFileAttributes;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.feature.input.FeatureInputImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.input.ImageMetadataInput;
import org.anchoranalysis.plugin.image.task.bean.feature.source.SingleRowPerInput;
import org.anchoranalysis.plugin.image.task.feature.FeatureCalculationContext;
import org.anchoranalysis.plugin.image.task.feature.ResultsVectorWithThumbnail;

public class FromImageMetadata
extends SingleRowPerInput<ImageMetadataInput, FeatureInputImageMetadata> {
    private static final String[] NON_GROUP_HEADERS = new String[]{"image", "extension", "creationTime", "lastModifiedTime", "acquisitionTime"};

    public FromImageMetadata() {
        super(NON_GROUP_HEADERS);
    }

    @Override
    public boolean includeGroupInExperiment(boolean groupGeneratorDefined) {
        return groupGeneratorDefined;
    }

    @Override
    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(ImageMetadataInput.class);
    }

    @Override
    protected Optional<String[]> additionalLabelsFor(ImageMetadataInput input) throws OperationFailedException {
        try {
            ImageFileAttributes attributes = input.metadata().getFileAttributes();
            return Optional.of(new String[]{attributes.extension().orElse(""), this.convertDate(attributes.getCreationTime()), this.convertDate(attributes.getModificationTime()), input.metadata().getAcquisitionTime().map(this::convertDate).orElse("")});
        }
        catch (ImageIOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected ResultsVectorWithThumbnail calculateResultsForInput(ImageMetadataInput input, FeatureCalculationContext<FeatureList<FeatureInputImageMetadata>> context) throws NamedFeatureCalculateException {
        return new ResultsVectorWithThumbnail((CheckedSupplier<ResultsVector, OperationFailedException>)((CheckedSupplier)() -> this.calculateResults(input, context)));
    }

    private ResultsVector calculateResults(ImageMetadataInput input, FeatureCalculationContext<FeatureList<FeatureInputImageMetadata>> context) throws OperationFailedException {
        try {
            FeatureInitialization initialization = new FeatureInitialization();
            FeatureCalculatorMulti calculator = FeatureSession.with(context.getFeatureSource(), (FeatureInitialization)initialization, (SharedFeatures)new SharedFeatures(), (Logger)context.getLogger());
            ImageMetadata metadata = (ImageMetadata)context.getExecutionTimeRecorder().recordExecutionTime("Reading image metadata", () -> ((ImageMetadataInput)input).metadata());
            return (ResultsVector)context.getExecutionTimeRecorder().recordExecutionTime("Calculating features", () -> calculator.calculate((FeatureInput)new FeatureInputImageMetadata(metadata)));
        }
        catch (InitializeException | NamedFeatureCalculateException | ImageIOException e) {
            throw new OperationFailedException(e);
        }
    }

    private String convertDate(ZonedDateTime date) {
        return date.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

