/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.format;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.value.StringUtilities;

class CalculateOutputName {
    private int seriesIndex;
    private int timeIndex;
    private int numberSeries;
    private int numberTimepoints;
    private boolean suppressSeries;

    public Optional<String> calculateOutputName(Optional<String> existingName) {
        return StringUtilities.joinNonEmpty((String)"_", (String[])new String[]{this.calculateSeriesComponent(), this.calculateTimeComponent(), existingName.orElse("")});
    }

    private String calculateSeriesComponent() {
        if (this.suppressSeries || this.numberSeries <= 1) {
            return "";
        }
        return String.format("%03d", this.seriesIndex);
    }

    private String calculateTimeComponent() {
        if (this.numberTimepoints <= 1) {
            return "";
        }
        return String.format("%05d", this.timeIndex);
    }

    @Generated
    public CalculateOutputName(int seriesIndex, int timeIndex, int numberSeries, int numberTimepoints, boolean suppressSeries) {
        this.seriesIndex = seriesIndex;
        this.timeIndex = timeIndex;
        this.numberSeries = numberSeries;
        this.numberTimepoints = numberTimepoints;
        this.suppressSeries = suppressSeries;
    }
}

