/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.grouped.histogram;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.task.bean.grouped.histogram.GroupedHistogramWriter;
import org.anchoranalysis.plugin.image.task.grouped.GroupMapByName;

class GroupedHistogramMap
extends GroupMapByName<Histogram, Histogram> {
    private final GroupedHistogramWriter writer;

    public GroupedHistogramMap(GroupedHistogramWriter writer, Optional<Stream<String>> groupIdentifiers, Optional<InputOutputContext> outputContext, int maxValue) {
        super("histogram", groupIdentifiers, outputContext, () -> new Histogram(maxValue), (single, aggregagor) -> aggregagor.addHistogram(single));
        this.writer = writer;
    }

    @Override
    protected void outputGroupIntoSubdirectory(Collection<Map.Entry<String, Histogram>> namedAggregators, Function<Boolean, InputOutputContext> createContext, Optional<String> outputNameSingle) throws IOException {
        Optional<Object> singleIdentifier = namedAggregators.size() > 1 ? Optional.empty() : outputNameSingle;
        InputOutputContext context = createContext.apply(namedAggregators.size() > 1);
        namedAggregators.forEach(namedAggregator -> this.writer.writeHistogramToFile((Histogram)namedAggregator.getValue(), singleIdentifier.orElse((String)namedAggregator.getKey()), context));
    }
}

