/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.bean.grouped.histogram;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.plugin.image.task.grouped.ChannelSource;

class MaskExtracter {
    public static Optional<Mask> extractMask(ChannelSource source, String maskStackName, int maskValue) throws OperationFailedException {
        if (!maskStackName.isEmpty()) {
            Channel extracted = source.extractChannel(maskStackName, false);
            return Optional.of(new Mask(extracted, MaskExtracter.createMaskBinaryValues(maskValue)));
        }
        return Optional.empty();
    }

    private static BinaryValuesInt createMaskBinaryValues(int maskValue) throws OperationFailedException {
        return switch (maskValue) {
            case 255 -> new BinaryValuesInt(0, 255);
            case 0 -> new BinaryValuesInt(255, 0);
            default -> throw new OperationFailedException("Only mask-values of 255 or 0 are currently supported");
        };
    }

    @Generated
    private MaskExtracter() {
    }
}

