/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.channel.aggregator;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;

public class NamedChannels
implements Iterable<Map.Entry<String, Channel>> {
    private Map<String, Channel> channels = new TreeMap<String, Channel>();
    private boolean rgb;

    public NamedChannels(boolean rgb) {
        this.rgb = rgb;
    }

    public NamedChannels(Stream<NamedChannels> channelsToCombine) throws OperationFailedException {
        boolean first = true;
        Iterator iterator = channelsToCombine.iterator();
        while (iterator.hasNext()) {
            NamedChannels source = (NamedChannels)iterator.next();
            if (first) {
                this.rgb = source.rgb;
                first = false;
            } else if (source.rgb != this.rgb) {
                throw new OperationFailedException("The rgb-state must be consistent to combine, but it is not");
            }
            this.addAll(source);
        }
    }

    @Override
    public Iterator<Map.Entry<String, Channel>> iterator() {
        return this.channels.entrySet().iterator();
    }

    public void add(String name, Channel channel) throws OperationFailedException {
        if (this.channels.containsKey(name)) {
            throw new OperationFailedException(String.format("A channel with name %s already exists", name));
        }
        this.channels.put(name, channel);
    }

    public Set<String> names() {
        return this.channels.keySet();
    }

    private void addAll(NamedChannels source) throws OperationFailedException {
        for (Map.Entry<String, Channel> entry : source.channels.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Generated
    public boolean isRgb() {
        return this.rgb;
    }
}

