/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.task.feature;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.input.FeatureInputResults;
import org.anchoranalysis.feature.io.csv.metadata.LabelHeaders;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.results.FeatureOutputMetadata;
import org.anchoranalysis.feature.io.results.FeatureOutputNames;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.feature.store.NamedFeatureStoreFactory;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.io.input.grouper.InputGrouper;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.plugin.image.task.feature.FeatureCalculationContext;
import org.anchoranalysis.plugin.image.task.feature.FeatureExporterContext;
import org.anchoranalysis.plugin.image.task.feature.FeatureResultsAndThumbnails;

public class FeatureExporter<S> {
    public static final String OUTPUT_THUMBNAILS = "thumbnails";
    private static final NamedFeatureStoreFactory STORE_FACTORY = NamedFeatureStoreFactory.parametersOnly();
    private final FeatureNameList featureNames;
    private final Supplier<S> featureSource;
    private FeatureResultsAndThumbnails results;
    private final Optional<InputGrouper> grouper;
    private FeatureExporterContext context;

    public FeatureExporter(FeatureOutputMetadata outputMetadata, Supplier<S> featureSource, Optional<InputGrouper> grouper, FeatureExporterContext context) throws OutputWriteFailedException {
        this.featureNames = outputMetadata.featureNamesNonAggregated();
        this.featureSource = featureSource;
        this.grouper = grouper;
        this.context = context;
        this.results = new FeatureResultsAndThumbnails(outputMetadata, context);
    }

    public static <T extends FeatureInput> FeatureExporter<FeatureList<T>> create(List<NamedBean<FeatureListProvider<T>>> features, LabelHeaders metadataHeaders, FeatureOutputNames outputNames, Optional<InputGrouper> grouper, FeatureExporterContext context) throws CreateException {
        try {
            return FeatureExporter.create(STORE_FACTORY.createNamedFeatureList(features), metadataHeaders, outputNames, grouper, context);
        }
        catch (ProvisionFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public static <T extends FeatureInput> FeatureExporter<FeatureList<T>> create(NamedFeatureStore<T> featureStore, LabelHeaders metadataHeaders, FeatureOutputNames outputNames, Optional<InputGrouper> grouper, FeatureExporterContext context) throws CreateException {
        try {
            return new FeatureExporter<FeatureList<T>>(new FeatureOutputMetadata(metadataHeaders, featureStore.featureNames(), outputNames), () -> ((NamedFeatureStore)featureStore.duplicate()).features(), grouper, context);
        }
        catch (OutputWriteFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public static <T extends FeatureInput> FeatureExporter<FeatureTableCalculator<T>> create(FeatureOutputNames outputNames, FeatureTableCalculator<T> features, LabelHeaders identifierHeaders, Optional<InputGrouper> grouper, FeatureExporterContext context) throws CreateException {
        try {
            return new FeatureExporter<FeatureTableCalculator<T>>(new FeatureOutputMetadata(identifierHeaders, features.createFeatureNames(), outputNames), () -> features.duplicateForNewThread(), grouper, context);
        }
        catch (OutputWriteFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    public FeatureCalculationContext<S> createCalculationContext(Optional<String> groupName, ExecutionTimeRecorder executionTimeRecorder, InputOutputContext ioContext) {
        return new FeatureCalculationContext<S>(this.results, this.featureSource.get(), this.featureNames, groupName, executionTimeRecorder, this.context.isSuppressErrors(), ioContext);
    }

    public void closeAndWriteOutputs(Optional<NamedFeatureStore<FeatureInputResults>> featuresAggregate, boolean includeGroups, Function<InputOutputContext, FeatureCSVWriterFactory> csvWriterCreator, InputOutputContext context) throws OutputWriteFailedException {
        try {
            this.results.writeGroupedResults(featuresAggregate, includeGroups, csvWriterCreator, context);
            this.results.closeAnyOpenIO();
            this.results = null;
        }
        catch (IOException | OutputWriteFailedException e) {
            throw new OutputWriteFailedException(e);
        }
    }

    @Generated
    public FeatureNameList getFeatureNames() {
        return this.featureNames;
    }

    @Generated
    public FeatureResultsAndThumbnails getResults() {
        return this.results;
    }

    @Generated
    public Optional<InputGrouper> getGrouper() {
        return this.grouper;
    }
}

